/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.client.gui.screens.inventory;

import neoforge.com.cursee.disenchanting_table.Constants;
import neoforge.com.cursee.disenchanting_table.DisEnchantingTable;
import neoforge.com.cursee.disenchanting_table.DisEnchantingTableClient;
import neoforge.com.cursee.disenchanting_table.core.world.block.entity.function.DisEnchantingStrategy;
import neoforge.com.cursee.disenchanting_table.core.world.inventory.DisEnchantingTableMenu;
import neoforge.com.cursee.disenchanting_table.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DisEnchantingTableScreen
extends AbstractContainerScreen<DisEnchantingTableMenu> {
    private static final Component MANUAL_MODE_TEXT = Component.translatable((String)"text.disenchanting_table.manual_mode");
    private static final Component AUTOMATIC_MODE_TEXT = Component.translatable((String)"text.disenchanting_table.automatic_mode");
    public static final ResourceLocation BACKGROUND = DisEnchantingTable.identifier("textures/gui/container/disenchanting_table.png");
    boolean automatic = false;
    PlainTextButton toggleButton;

    public DisEnchantingTableScreen(DisEnchantingTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.font = Minecraft.getInstance().font;
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            this.createToggleButton();
        }
    }

    public void createToggleButton() {
        if (!Services.PLATFORM.isDevelopmentEnvironment()) {
            return;
        }
        Component currentMode = !this.automatic ? MANUAL_MODE_TEXT : AUTOMATIC_MODE_TEXT;
        this.toggleButton = (PlainTextButton)this.addRenderableWidget((GuiEventListener)new PlainTextButton(15, 15, this.font.width((FormattedText)currentMode), 10, currentMode, this::onPressToggleButton, this.font));
    }

    public void onPressToggleButton(Button button) {
        Constants.LOG.info("Clicked!");
        this.automatic = !this.automatic;
        this.rebuildWidgets();
    }

    protected void rebuildWidgets() {
        super.rebuildWidgets();
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            this.createToggleButton();
        }
    }

    protected void init() {
        super.init();
        this.titleLabelY += 9999;
        this.inventoryLabelY += 9999;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (DisEnchantingTableClient.render_experience_cost && !DisEnchantingStrategy.hasEnoughExperience((Player)Minecraft.getInstance().player)) {
            int textPadding = 4;
            int xStart = this.leftPos + 45;
            int yStart = this.topPos + 72;
            MutableComponent text = Component.literal((String)"Insufficient Experience!");
            guiGraphics.fill(xStart, yStart, xStart + this.font.width((FormattedText)text) + 4, yStart + 11, -12242305);
            guiGraphics.drawString(this.font, (Component)text, xStart + 2, yStart + 2, -40864);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

