/*
 * Decompiled with CFR 0.152.
 */
package plugin.echoblock.xp2hp.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import plugin.echoblock.xp2hp.XP2HPPlugin;

public class ExperienceHealthHandler
implements Listener {
    private final XP2HPPlugin plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ExperienceHealthHandler(XP2HPPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void handleExperienceGain(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin, location, task -> this.updateHealth(player), 1L);
    }

    @EventHandler
    public void handlePlayerJoin(PlayerJoinEvent event) {
        this.updateHealth(event.getPlayer());
    }

    @EventHandler
    public void handlePlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Location location = player.getLocation();
        Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin, location, task -> this.updateHealth(player), 10L);
    }

    @EventHandler
    public void handlePlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Location location = player.getLocation();
        Bukkit.getRegionScheduler().run((Plugin)this.plugin, location, task -> {
            boolean keepInventory = Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY));
            if (!keepInventory) {
                AttributeInstance healthAttr = player.getAttribute(Attribute.MAX_HEALTH);
                if (healthAttr != null) {
                    healthAttr.setBaseValue(20.0);
                }
                this.plugin.getStatBoostHandler().clearStatBoost(player);
            }
        });
    }

    public void updateHealth(Player player) {
        try {
            if (!(player.hasPermission("xp2hp.use") || player.hasPermission("x2h.use") || player.hasPermission("xh.use") || player.hasPermission("xph.use"))) {
                return;
            }
            int currentLevel = player.getLevel();
            AttributeInstance healthAttr = player.getAttribute(Attribute.MAX_HEALTH);
            if (healthAttr == null) {
                this.plugin.getLogger().warning("Player " + player.getName() + " is missing MAX_HEALTH attribute.");
                return;
            }
            double currentHealth = healthAttr.getBaseValue();
            for (int level = currentLevel; level >= 0; --level) {
                if (!this.plugin.getConfigManager().getHealthMap().containsKey(level)) continue;
                double configuredHealth = this.plugin.getConfigManager().getHealthMap().get(level);
                if (configuredHealth == currentHealth) break;
                healthAttr.setBaseValue(configuredHealth);
                if (this.plugin.getConfigManager().shouldHealOnUpdate()) {
                    player.getScheduler().runDelayed((Plugin)this.plugin, t -> {
                        AttributeInstance max = player.getAttribute(Attribute.MAX_HEALTH);
                        if (max != null) {
                            double finalizedMax = max.getValue();
                            player.setHealth(finalizedMax);
                        }
                    }, null, 1L);
                }
                if (!this.plugin.getConfigManager().shouldNotifyOnlyExactLevels() || !this.plugin.getConfigManager().getNotifyAtLevels().contains(currentLevel)) break;
                Component message = this.miniMessage.deserialize((Object)this.plugin.getConfigManager().getHealthUpdateNotification());
                player.sendMessage(message);
                break;
            }
            this.plugin.getStatBoostHandler().applyStatBoost(player);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update health: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

