/*
 * Decompiled with CFR 0.152.
 */
package plugin.echoblock.xp2hp.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameRule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import plugin.echoblock.xp2hp.XP2HPPlugin;
import plugin.echoblock.xp2hp.managers.ConfigManager;

public class NaturalRegenController
implements Listener {
    private final XP2HPPlugin plugin;
    private final Map<UUID, Long> lastTick = new HashMap<UUID, Long>();

    public NaturalRegenController(XP2HPPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onNaturalRegen(EntityRegainHealthEvent e) {
        int level;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        Boolean gr = (Boolean)p.getWorld().getGameRuleValue(GameRule.NATURAL_REGENERATION);
        if (Boolean.FALSE.equals(gr)) {
            return;
        }
        ConfigManager cfg = this.plugin.getConfigManager();
        ConfigManager.NaturalRegenSettings settings = null;
        for (int i = level = p.getLevel(); i >= 0 && (settings = cfg.getNaturalRegenMap().get(i)) == null; --i) {
        }
        if (settings == null) {
            return;
        }
        long now = p.getWorld().getFullTime();
        Long last = this.lastTick.get(p.getUniqueId());
        if (last != null && now - last < settings.cooldownTicks) {
            e.setCancelled(true);
            return;
        }
        double scaled = e.getAmount() * settings.multiplier;
        if (scaled <= 0.0) {
            e.setCancelled(true);
            return;
        }
        e.setAmount(scaled);
        this.lastTick.put(p.getUniqueId(), now);
    }
}

