/*
 * Decompiled with CFR 0.152.
 */
package plugin.echoblock.xp2hp.listeners;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import plugin.echoblock.xp2hp.XP2HPPlugin;

public class StatBoostHandler {
    private final XP2HPPlugin plugin;

    public StatBoostHandler(XP2HPPlugin plugin) {
        this.plugin = plugin;
    }

    public void applyStatBoost(Player player) {
        Attribute[] managedAttributes;
        int level = player.getLevel();
        Map<Integer, List<Map.Entry<String, Double>>> boosts = this.plugin.getConfigManager().getStatBoostMap();
        for (Attribute attribute : managedAttributes = new Attribute[]{Attribute.MOVEMENT_SPEED, Attribute.ATTACK_KNOCKBACK, Attribute.ATTACK_DAMAGE, Attribute.ATTACK_SPEED, Attribute.ARMOR, Attribute.SCALE, Attribute.LUCK, Attribute.KNOCKBACK_RESISTANCE}) {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) continue;
            double defaultValue = this.getDefaultValue(attribute);
            instance.setBaseValue(defaultValue);
        }
        for (int i = level; i >= 0; --i) {
            if (!boosts.containsKey(i)) continue;
            List<Map.Entry<String, Double>> entries = boosts.get(i);
            for (Map.Entry<String, Double> entry : entries) {
                AttributeInstance instance;
                String key = entry.getKey().replace("minecraft:", "").replace('.', '_').toUpperCase(Locale.ROOT);
                Attribute attribute = this.matchAttribute(key);
                if (attribute == null || attribute == Attribute.MAX_HEALTH || (instance = player.getAttribute(attribute)) == null) continue;
                instance.setBaseValue(this.getDefaultValue(attribute) + entry.getValue());
            }
            break;
        }
    }

    public void clearStatBoost(Player player) {
        Attribute[] managedAttributes;
        for (Attribute attribute : managedAttributes = new Attribute[]{Attribute.MOVEMENT_SPEED, Attribute.ATTACK_KNOCKBACK, Attribute.ATTACK_DAMAGE, Attribute.ATTACK_SPEED, Attribute.ARMOR, Attribute.SCALE, Attribute.LUCK, Attribute.KNOCKBACK_RESISTANCE}) {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) continue;
            instance.setBaseValue(this.getDefaultValue(attribute));
        }
    }

    private double getDefaultValue(Attribute attribute) {
        if (attribute == Attribute.MOVEMENT_SPEED) {
            return 0.1;
        }
        if (attribute == Attribute.ATTACK_KNOCKBACK) {
            return 0.0;
        }
        if (attribute == Attribute.ATTACK_SPEED) {
            return 4.0;
        }
        if (attribute == Attribute.ATTACK_DAMAGE) {
            return 1.0;
        }
        if (attribute == Attribute.ARMOR) {
            return 0.0;
        }
        if (attribute == Attribute.SCALE) {
            return 1.0;
        }
        if (attribute == Attribute.LUCK) {
            return 0.0;
        }
        if (attribute == Attribute.KNOCKBACK_RESISTANCE) {
            return 0.0;
        }
        return 0.0;
    }

    private Attribute matchAttribute(String key) {
        return switch (key) {
            case "MOVEMENT_SPEED" -> Attribute.MOVEMENT_SPEED;
            case "ATTACK_KNOCKBACK" -> Attribute.ATTACK_KNOCKBACK;
            case "ATTACK_SPEED" -> Attribute.ATTACK_SPEED;
            case "ATTACK_DAMAGE" -> Attribute.ATTACK_DAMAGE;
            case "ARMOR" -> Attribute.ARMOR;
            case "SCALE" -> Attribute.SCALE;
            case "LUCK" -> Attribute.LUCK;
            case "KNOCKBACK_RESISTANCE" -> Attribute.KNOCKBACK_RESISTANCE;
            case "MAX_HEALTH" -> Attribute.MAX_HEALTH;
            default -> null;
        };
    }
}

