/*
 * Decompiled with CFR 0.152.
 */
package plugin.echoblock.xp2hp.managers;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import plugin.echoblock.xp2hp.XP2HPPlugin;

public class ConfigManager {
    private final XP2HPPlugin plugin;
    private final HashMap<Integer, Double> healthByLevel = new HashMap();
    private final Map<Integer, List<Map.Entry<String, Double>>> statBoosts = new HashMap<Integer, List<Map.Entry<String, Double>>>();
    private final Set<Integer> notifyAtLevels = new HashSet<Integer>();
    private boolean notifyOnlyExactLevels = false;
    private final Map<Integer, NaturalRegenSettings> naturalRegenByLevel = new HashMap<Integer, NaturalRegenSettings>();
    private File configFile;
    private FileConfiguration config;

    public ConfigManager(XP2HPPlugin plugin) {
        this.plugin = plugin;
    }

    public HashMap<Integer, Double> getHealthMap() {
        return this.healthByLevel;
    }

    public Map<Integer, List<Map.Entry<String, Double>>> getStatBoostMap() {
        return this.statBoosts;
    }

    public Map<Integer, NaturalRegenSettings> getNaturalRegenMap() {
        return this.naturalRegenByLevel;
    }

    public String getHealthUpdateNotification() {
        return this.config.getString("max-health-update-message", "<green><bold>You are growing Stronger!</bold></green>");
    }

    public boolean shouldHealOnUpdate() {
        return this.config.getBoolean("heal-on-health-update", true);
    }

    public boolean isUnsafeLevelAllowed() {
        return this.config.getBoolean("allow-unsafe-levels", false);
    }

    public boolean shouldNotifyOnlyExactLevels() {
        return this.notifyOnlyExactLevels;
    }

    public Set<Integer> getNotifyAtLevels() {
        return this.notifyAtLevels;
    }

    public void initializeConfig() {
        block16: {
            File pluginFolder = this.plugin.getDataFolder();
            if (!pluginFolder.exists() && !pluginFolder.mkdir()) {
                this.plugin.getLogger().warning("Could not create plugin folder.");
            }
            this.configFile = new File(pluginFolder, "config.yml");
            if (!this.configFile.exists()) {
                try {
                    if (!this.configFile.createNewFile()) break block16;
                    try (InputStream in = this.plugin.getResource("config.yml");
                         FileOutputStream out = new FileOutputStream(this.configFile);){
                        if (in != null) {
                            ByteStreams.copy((InputStream)in, (OutputStream)out);
                        }
                    }
                }
                catch (Exception ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to create the configuration file.", ex);
                }
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reloadConfig() {
        this.initializeConfig();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.healthByLevel.clear();
        this.statBoosts.clear();
        this.notifyAtLevels.clear();
        this.naturalRegenByLevel.clear();
        try {
            for (String key : Objects.requireNonNull(this.config.getConfigurationSection("max-health-on-level")).getKeys(false)) {
                int level = Integer.parseInt(key);
                double health = this.config.getDouble("max-health-on-level." + key);
                this.healthByLevel.put(level, health);
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "[XP2HP] Error reading config. Please correct or reset your config file.", ex);
        }
        if (this.config.contains("stat-boost-on-level")) {
            for (String key : Objects.requireNonNull(this.config.getConfigurationSection("stat-boost-on-level")).getKeys(false)) {
                try {
                    int level = Integer.parseInt(key);
                    List entries = this.config.getStringList("stat-boost-on-level." + key);
                    ArrayList<Map.Entry<String, Double>> parsed = new ArrayList<Map.Entry<String, Double>>();
                    for (String entry : entries) {
                        if (!entry.contains(";")) continue;
                        String[] parts = entry.split(";", 2);
                        String rawAttr = parts[0].toLowerCase(Locale.ROOT);
                        String attrNoNs = rawAttr.replace("minecraft:", "");
                        if ("natural_regen".equals(attrNoNs)) {
                            String[] vals = parts[1].split(",", 2);
                            double mult = Double.parseDouble(vals[0].trim());
                            long cd = Long.parseLong((vals.length > 1 ? vals[1] : "0").trim());
                            this.naturalRegenByLevel.put(level, new NaturalRegenSettings(mult, cd));
                            continue;
                        }
                        double value = Double.parseDouble(parts[1].trim());
                        parsed.add(Map.entry(rawAttr, value));
                    }
                    this.statBoosts.put(level, parsed);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Invalid stat boost entries at level " + key + ": " + e.getMessage());
                }
            }
        }
        this.notifyOnlyExactLevels = this.config.getBoolean("notify-only-exact-levels", false);
        this.notifyAtLevels.addAll(this.config.getIntegerList("notify-at-levels"));
    }

    public static final class NaturalRegenSettings {
        public final double multiplier;
        public final long cooldownTicks;

        public NaturalRegenSettings(double multiplier, long cooldownTicks) {
            this.multiplier = multiplier;
            this.cooldownTicks = cooldownTicks;
        }
    }
}

