/*
 * Decompiled with CFR 0.152.
 */
package plugin.echoblock.xp2hp.commands;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plugin.echoblock.xp2hp.XP2HPPlugin;
import plugin.echoblock.xp2hp.listeners.ExperienceHealthHandler;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final XP2HPPlugin plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public CommandHandler(XP2HPPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (sender == null) {
            CommandHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            CommandHandler.$$$reportNull$$$0(1);
        }
        if (label == null) {
            CommandHandler.$$$reportNull$$$0(2);
        }
        if (args == null) {
            CommandHandler.$$$reportNull$$$0(3);
        }
        if (!command.getName().equalsIgnoreCase("xp2hp")) {
            return false;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "info": {
                this.sendInfo(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "get": {
                this.handleGet(sender, args);
                break;
            }
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(this.mm.deserialize((Object)"<yellow>/xp2hp <info|reload|get|set>"));
    }

    private void sendInfo(CommandSender sender) {
        sender.sendMessage(this.mm.deserialize("<gold>Plugin: <reset><plugin>", (TagResolver)Placeholder.unparsed((String)"plugin", (String)this.plugin.getDescription().getName())));
        sender.sendMessage(this.mm.deserialize("<gold>Version: <reset><version>", (TagResolver)Placeholder.unparsed((String)"version", (String)this.plugin.getDescription().getVersion())));
        sender.sendMessage(this.mm.deserialize("<gold>Authors: <reset><authors>", (TagResolver)Placeholder.unparsed((String)"authors", (String)this.plugin.getDescription().getAuthors().toString())));
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("xp2hp.admin")) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>You don't have permission to reload the config."));
            return;
        }
        this.plugin.getConfigManager().reloadConfig();
        sender.sendMessage(this.mm.deserialize((Object)"<green>XP2HP config reloaded."));
    }

    private void handleGet(CommandSender sender, String[] args) {
        Player target;
        if (!(sender instanceof Player) && args.length < 2) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Usage: /xp2hp get <player>"));
            return;
        }
        Player player = target = args.length >= 2 ? Bukkit.getPlayer((String)args[1]) : (Player)sender;
        if (target == null) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Player not found."));
            return;
        }
        double health = Objects.requireNonNull(target.getAttribute(Attribute.MAX_HEALTH)).getBaseValue();
        double damage = this.getStat(target, Attribute.ATTACK_DAMAGE);
        double armor = this.getStat(target, Attribute.ARMOR);
        double speed = this.getStat(target, Attribute.MOVEMENT_SPEED);
        sender.sendMessage(this.mm.deserialize("<gray><player>'s Stats:</gray>", (TagResolver)Placeholder.unparsed((String)"player", (String)target.getName())));
        sender.sendMessage(this.mm.deserialize("<yellow>Health: <white><val>", (TagResolver)Placeholder.unparsed((String)"val", (String)String.valueOf(health))));
        sender.sendMessage(this.mm.deserialize("<yellow>Attack Damage: <white><val>", (TagResolver)Placeholder.unparsed((String)"val", (String)String.valueOf(damage))));
        sender.sendMessage(this.mm.deserialize("<yellow>Armor: <white><val>", (TagResolver)Placeholder.unparsed((String)"val", (String)String.valueOf(armor))));
        sender.sendMessage(this.mm.deserialize("<yellow>Speed: <white><val>", (TagResolver)Placeholder.unparsed((String)"val", (String)String.valueOf(speed))));
    }

    private void handleSet(CommandSender sender, String[] args) {
        int level;
        if (!sender.hasPermission("xp2hp.admin.set")) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>You lack permission to use this command."));
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Usage: /xp2hp set <player> <level>"));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Target player not found."));
            return;
        }
        try {
            level = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Invalid level: must be a number."));
            return;
        }
        if (!(this.plugin.getConfigManager().isUnsafeLevelAllowed() || level >= 0 && level <= 400)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Level must be between 0 and 400. (Set allow-unsafe-levels to true in config to override.)"));
            return;
        }
        target.setLevel(level);
        try {
            ExperienceHealthHandler handler = new ExperienceHealthHandler(this.plugin);
            Method m = ExperienceHealthHandler.class.getDeclaredMethod("updateHealth", Player.class);
            m.setAccessible(true);
            m.invoke((Object)handler, target);
        }
        catch (Exception e) {
            sender.sendMessage(this.mm.deserialize("<red>Failed to update health: <error>", (TagResolver)Placeholder.unparsed((String)"error", (String)e.getMessage())));
            return;
        }
        sender.sendMessage(this.mm.deserialize("<green>Set <player>'s level to <level> and updated their health.", new TagResolver[]{Placeholder.unparsed((String)"player", (String)target.getName()), Placeholder.unparsed((String)"level", (String)String.valueOf(level))}));
    }

    private double getStat(Player player, Attribute attribute) {
        AttributeInstance attr = player.getAttribute(attribute);
        return attr != null ? attr.getBaseValue() : 0.0;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (sender == null) {
            CommandHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            CommandHandler.$$$reportNull$$$0(5);
        }
        if (alias == null) {
            CommandHandler.$$$reportNull$$$0(6);
        }
        if (args == null) {
            CommandHandler.$$$reportNull$$$0(7);
        }
        if (!command.getName().equalsIgnoreCase("xp2hp")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Stream.of("info", "reload", "get", "set").filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("get") || args[0].equalsIgnoreCase("set"))) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        objectArray2[1] = "plugin/echoblock/xp2hp/commands/CommandHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onTabComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

