/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p;

import appeng.api.parts.IPartItem;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.parts.p2p.FEP2PTunnelPart;
import appeng.parts.p2p.FluidP2PTunnelPart;
import appeng.parts.p2p.ItemP2PTunnelPart;
import appeng.parts.p2p.LightP2PTunnelPart;
import appeng.parts.p2p.MEP2PTunnelPart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.parts.p2p.RedstoneP2PTunnelPart;
import dev.lasm.betterp2p.BetterP2P;
import dev.lasm.betterp2p.util.p2p.TunnelInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0006H\u0002J&\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u000bJ\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00072\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0006J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eR$\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001f"}, d2={"Ldev/lasm/betterp2p/CommonProxy;", "", "<init>", "()V", "tunnelTypes", "", "Ljava/lang/Class;", "Ldev/lasm/betterp2p/util/p2p/TunnelInfo;", "getTunnelTypes", "()Ljava/util/Map;", "tunnelIndices", "", "getTunnelIndices", "initTunnels", "", "registerTunnel", "def", "Lappeng/core/definitions/ItemDefinition;", "type", "classType", "Lappeng/parts/p2p/P2PTunnelPart;", "registerModTunnel", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item;", "", "getP2PFromIndex", "index", "getP2PFromClass", "clazz", "getP2PTypeList", "", "betterp2p"})
public class CommonProxy {
    @NotNull
    private final Map<Class<?>, TunnelInfo> tunnelTypes = new LinkedHashMap();
    @NotNull
    private final Map<Integer, TunnelInfo> tunnelIndices = new LinkedHashMap();

    @NotNull
    protected final Map<Class<?>, TunnelInfo> getTunnelTypes() {
        return this.tunnelTypes;
    }

    @NotNull
    protected final Map<Integer, TunnelInfo> getTunnelIndices() {
        return this.tunnelIndices;
    }

    public void initTunnels() {
        int typeId = 0;
        ItemDefinition itemDefinition = AEParts.ME_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition, (String)"ME_P2P_TUNNEL");
        this.registerTunnel(itemDefinition, typeId++, MEP2PTunnelPart.class);
        ItemDefinition itemDefinition2 = AEParts.FE_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition2, (String)"FE_P2P_TUNNEL");
        this.registerTunnel(itemDefinition2, typeId++, FEP2PTunnelPart.class);
        ItemDefinition itemDefinition3 = AEParts.REDSTONE_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition3, (String)"REDSTONE_P2P_TUNNEL");
        this.registerTunnel(itemDefinition3, typeId++, RedstoneP2PTunnelPart.class);
        ItemDefinition itemDefinition4 = AEParts.FLUID_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition4, (String)"FLUID_P2P_TUNNEL");
        this.registerTunnel(itemDefinition4, typeId++, FluidP2PTunnelPart.class);
        ItemDefinition itemDefinition5 = AEParts.ITEM_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition5, (String)"ITEM_P2P_TUNNEL");
        this.registerTunnel(itemDefinition5, typeId++, ItemP2PTunnelPart.class);
        ItemDefinition itemDefinition6 = AEParts.LIGHT_P2P_TUNNEL;
        Intrinsics.checkNotNullExpressionValue((Object)itemDefinition6, (String)"LIGHT_P2P_TUNNEL");
        this.registerTunnel(itemDefinition6, typeId++, LightP2PTunnelPart.class);
        this.registerModTunnel(CommonProxy::initTunnels$lambda$0, typeId++, "me.ramidzkh.mekae2.ae2.ChemicalP2PTunnelPart");
        this.registerModTunnel(CommonProxy::initTunnels$lambda$1, typeId++, "stone.mae2.parts.p2p.PatternP2PTunnelPart");
        if (ModList.get().isLoaded("gtceu")) {
            this.registerModTunnel(CommonProxy::initTunnels$lambda$2, typeId++, "stone.mae2.parts.p2p.EUP2PTunnelPart");
        }
    }

    private final void registerTunnel(ItemDefinition<?> def, int type, Class<? extends P2PTunnelPart<?>> classType) {
        ItemStack stack = def.stack(1);
        Intrinsics.checkNotNull((Object)stack);
        TunnelInfo info2 = new TunnelInfo(type, stack, classType);
        this.tunnelTypes.put(classType, info2);
        this.tunnelIndices.put(type, info2);
    }

    private final void registerModTunnel(Supplier<Item> def, int type, String classType) {
        try {
            Class<?> clazz = Class.forName(classType);
            ItemStack stack = new ItemStack((ItemLike)def.get());
            if (!P2PTunnelPart.class.isAssignableFrom(clazz) || !(def.get() instanceof IPartItem)) {
                BetterP2P.INSTANCE.getLogger().error("Found mod support {} but it's not a P2P tunnel, this indicates a mod update, please report it to BetterP2P repository", (Object)classType);
            }
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out appeng.parts.p2p.P2PTunnelPart<*>>");
            TunnelInfo info2 = new TunnelInfo(type, stack, clazz);
            this.tunnelTypes.put(clazz, info2);
            this.tunnelIndices.put(type, info2);
        }
        catch (ClassNotFoundException e) {
            BetterP2P.INSTANCE.getLogger().error("Mod support for {} not found", (Object)classType);
        }
        catch (NullPointerException e) {
            BetterP2P.INSTANCE.getLogger().error("Mod support for {} not found", (Object)classType);
        }
    }

    @Nullable
    public final TunnelInfo getP2PFromIndex(int index) {
        if (this.tunnelTypes.isEmpty()) {
            this.initTunnels();
        }
        return this.tunnelIndices.get(index);
    }

    @Nullable
    public final TunnelInfo getP2PFromClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.tunnelTypes.isEmpty()) {
            this.initTunnels();
        }
        return this.tunnelTypes.get(clazz);
    }

    @NotNull
    public final List<TunnelInfo> getP2PTypeList() {
        return CollectionsKt.toList((Iterable)this.tunnelIndices.values());
    }

    private static final Item initTunnels$lambda$0() {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"appmek", (String)"chemical_p2p_tunnel"));
    }

    private static final Item initTunnels$lambda$1() {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mae2", (String)"pattern_p2p_tunnel"));
    }

    private static final Item initTunnels$lambda$2() {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mae2", (String)"eu_p2p_tunnel"));
    }
}

