/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.item;

import appeng.api.networking.IGrid;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.parts.p2p.P2PTunnelPart;
import dev.lasm.betterp2p.BetterP2P;
import dev.lasm.betterp2p.client.ClientCache;
import dev.lasm.betterp2p.network.ModNetwork;
import dev.lasm.betterp2p.network.data.MemoryInfo;
import dev.lasm.betterp2p.network.data.P2PLocation;
import dev.lasm.betterp2p.network.data.P2PLocationKt;
import dev.lasm.betterp2p.util.p2p.P2PUtilKt;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Ldev/lasm/betterp2p/item/ItemAdvancedMemoryCard;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "useOn", "Lnet/minecraft/world/InteractionResult;", "useOnContext", "Lnet/minecraft/world/item/context/UseOnContext;", "betterp2p"})
public final class ItemAdvancedMemoryCard
extends Item {
    @NotNull
    public static final ItemAdvancedMemoryCard INSTANCE = new ItemAdvancedMemoryCard();

    private ItemAdvancedMemoryCard() {
        super(new Item.Properties().stacksTo(1).component((Supplier)BetterP2P.INSTANCE.getMEMORY_INFO(), (Object)new MemoryInfo(null, 0, null, null, 0, 31, null)));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Object object = stack.getComponents().get((DataComponentType)BetterP2P.INSTANCE.getMEMORY_INFO().get());
        Intrinsics.checkNotNull((Object)object);
        MemoryInfo info2 = (MemoryInfo)object;
        String string = info2.getMode().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        MutableComponent mutableComponent = Component.translatable((String)("gui.advanced_memory_card.mode." + string));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        list.add((Component)mutableComponent);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (player.isCrouching() && !level.isClientSide) {
            ClientCache.INSTANCE.clear();
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(level, player, interactionHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext useOnContext) {
        Intrinsics.checkNotNullParameter((Object)useOnContext, (String)"useOnContext");
        Level w = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        Player player2 = player;
        ItemStack stack = useOnContext.getItemInHand();
        BlockPos pos = useOnContext.getClickedPos();
        if (w.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockEntity te = w.getBlockEntity(pos);
        if (te instanceof IInWorldGridNodeHost && te instanceof IPartHost) {
            IPart part;
            IPart iPart;
            IPart iPart2 = ((IPartHost)te).selectPartWorld((Vec3)useOnContext.getClickLocation()).part;
            if (iPart2 == null) {
                iPart2 = ((IPartHost)te).getPart(null);
            }
            if ((iPart = (part = iPart2)) == null || (iPart = iPart.getGridNode()) == null || (iPart = iPart.getGrid()) == null) {
                return InteractionResult.FAIL;
            }
            IPart grid = iPart;
            Object object = stack.getComponents().get((DataComponentType)BetterP2P.INSTANCE.getMEMORY_INFO().get());
            Intrinsics.checkNotNull((Object)object);
            MemoryInfo info2 = (MemoryInfo)object;
            Optional<P2PLocation> selectedEntry = null;
            int type = 0;
            if (part instanceof P2PTunnelPart) {
                type = P2PUtilKt.getTypeIndex((P2PTunnelPart)part);
                Optional<P2PLocation> optional = Optional.of(P2PLocationKt.toLoc((P2PTunnelPart)part));
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                selectedEntry = optional;
            } else {
                type = -1;
                Optional<P2PLocation> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                selectedEntry = optional;
            }
            MemoryInfo info1 = new MemoryInfo(selectedEntry, info2.getFrequency(), info2.getMode(), info2.getGuiScale(), type);
            stack.update((Supplier)BetterP2P.INSTANCE.getMEMORY_INFO(), (Object)new MemoryInfo(null, 0, null, null, 0, 31, null), arg_0 -> ItemAdvancedMemoryCard.useOn$lambda$0(info1, arg_0));
            ModNetwork.INSTANCE.initConnection(player2, (IGrid)grid, info1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static final MemoryInfo useOn$lambda$0(MemoryInfo $info1, MemoryInfo info2) {
        return $info1;
    }
}

