/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network;

import appeng.api.networking.IGrid;
import dev.lasm.betterp2p.client.AdvancedMemoryCardMenu;
import dev.lasm.betterp2p.network.PlayerRequest;
import dev.lasm.betterp2p.network.data.GridServerCache;
import dev.lasm.betterp2p.network.data.MemoryInfo;
import dev.lasm.betterp2p.network.packet.C2SChangeP2PType;
import dev.lasm.betterp2p.network.packet.C2SChangeP2PTypeKt;
import dev.lasm.betterp2p.network.packet.C2SCloseGui;
import dev.lasm.betterp2p.network.packet.C2SCloseGuiKt;
import dev.lasm.betterp2p.network.packet.C2SLinkP2P;
import dev.lasm.betterp2p.network.packet.C2SLinkP2PKt;
import dev.lasm.betterp2p.network.packet.C2SRefreshP2PList;
import dev.lasm.betterp2p.network.packet.C2SRefreshP2PListKt;
import dev.lasm.betterp2p.network.packet.C2SRenameP2P;
import dev.lasm.betterp2p.network.packet.C2SRenameP2PKt;
import dev.lasm.betterp2p.network.packet.C2SUnlinkP2P;
import dev.lasm.betterp2p.network.packet.C2SUnlinkP2PKt;
import dev.lasm.betterp2p.network.packet.C2SUpdateMemoryInfo;
import dev.lasm.betterp2p.network.packet.C2SUpdateMemoryInfoKt;
import dev.lasm.betterp2p.network.packet.S2COpenGui;
import dev.lasm.betterp2p.network.packet.S2COpenGuiKt;
import dev.lasm.betterp2p.network.packet.S2CUpdateP2P;
import dev.lasm.betterp2p.network.packet.S2CUpdateP2PKt;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Ldev/lasm/betterp2p/network/ModNetwork;", "", "<init>", "()V", "playerState", "", "Ljava/util/UUID;", "Ldev/lasm/betterp2p/network/PlayerRequest;", "getPlayerState", "()Ljava/util/Map;", "registerNetwork", "", "event", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "requestP2PList", "player", "Lnet/minecraft/world/entity/player/Player;", "type", "", "requestP2PUpdate", "initConnection", "grid", "Lappeng/api/networking/IGrid;", "info", "Ldev/lasm/betterp2p/network/data/MemoryInfo;", "removeConnection", "betterp2p"})
public final class ModNetwork {
    @NotNull
    public static final ModNetwork INSTANCE = new ModNetwork();
    @NotNull
    private static final Map<UUID, PlayerRequest> playerState;

    private ModNetwork() {
    }

    @NotNull
    public final Map<UUID, PlayerRequest> getPlayerState() {
        return playerState;
    }

    public final void registerNetwork(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar reg = event.registrar("1").executesOn(HandlerThread.NETWORK);
        reg.playToClient(S2COpenGui.Companion.getTYPE(), S2COpenGui.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$0(S2COpenGuiKt.getClientOpenGuiHandler(), arg_0, arg_1));
        reg.playToClient(S2CUpdateP2P.Companion.getTYPE(), S2CUpdateP2P.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$1(S2CUpdateP2PKt.getClientUpdateP2PHandler(), arg_0, arg_1));
        reg.playToServer(C2SLinkP2P.Companion.getTYPE(), C2SLinkP2P.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$2(C2SLinkP2PKt.getServerLinkP2PHandler(), arg_0, arg_1));
        reg.playToServer(C2SCloseGui.Companion.getTYPE(), C2SCloseGui.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$3(C2SCloseGuiKt.getServerCloseGuiHandler(), arg_0, arg_1));
        reg.playToServer(C2SUpdateMemoryInfo.Companion.getTYPE(), C2SUpdateMemoryInfo.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$4(C2SUpdateMemoryInfoKt.getServerUpdateMemoryInfoHandler(), arg_0, arg_1));
        reg.playToServer(C2SRenameP2P.Companion.getTYPE(), C2SRenameP2P.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$5(C2SRenameP2PKt.getServerRenameP2PTunnelHandler(), arg_0, arg_1));
        reg.playToServer(C2SRefreshP2PList.Companion.getTYPE(), C2SRefreshP2PList.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$6(C2SRefreshP2PListKt.getServerRefreshP2PListHandler(), arg_0, arg_1));
        reg.playToServer(C2SUnlinkP2P.Companion.getTYPE(), C2SUnlinkP2P.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$7(C2SUnlinkP2PKt.getServerUnlinkP2PHandler(), arg_0, arg_1));
        reg.playToServer(C2SChangeP2PType.Companion.getTYPE(), C2SChangeP2PType.Companion.getSTREAM_CODEC(), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$8(C2SChangeP2PTypeKt.getServerTypeChangeHandler(), arg_0, arg_1));
    }

    public final void requestP2PList(@NotNull Player player, int type) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerRequest playerRequest = playerState.get(player.getUUID());
        if (playerRequest == null) {
            return;
        }
        PlayerRequest playerState = playerRequest;
        GridServerCache cache = playerState.getGridCache();
        cache.setType(type);
        if (playerState.getUpdateReady$betterp2p() + 200L < System.currentTimeMillis()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2CUpdateP2P(cache.retrieveP2PList(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 200L);
        } else if (!playerState.getUpdatePending$betterp2p()) {
            playerState.setUpdatePending$betterp2p(true);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2CUpdateP2P(cache.retrieveP2PList(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            playerState.setUpdatePending$betterp2p(false);
        }
    }

    public final void requestP2PUpdate(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerRequest playerRequest = playerState.get(player.getUUID());
        if (playerRequest == null) {
            return;
        }
        PlayerRequest playerState = playerRequest;
        GridServerCache cache = playerState.getGridCache();
        if (playerState.getUpdateReady$betterp2p() + 200L < System.currentTimeMillis()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2CUpdateP2P(cache.getP2PUpdates(), false, 2, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 200L);
        } else if (!playerState.getUpdatePending$betterp2p()) {
            playerState.setUpdatePending$betterp2p(true);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2CUpdateP2P(cache.getP2PUpdates(), false, 2, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            playerState.setUpdatePending$betterp2p(false);
        }
    }

    public final void initConnection(@NotNull Player player, @NotNull IGrid grid, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        GridServerCache cache = new GridServerCache(grid, player, info2.getType());
        playerState.put(player.getUUID(), new PlayerRequest(false, 0L, cache, 3, null));
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ((ServerPlayer)player).openMenu(new MenuProvider(info2, cache){
            final /* synthetic */ MemoryInfo $info;
            final /* synthetic */ GridServerCache $cache;
            {
                this.$info = $info;
                this.$cache = $cache;
            }

            public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                AdvancedMemoryCardMenu advancedMemoryCardMenu = new AdvancedMemoryCardMenu(id, inventory);
                MemoryInfo memoryInfo = this.$info;
                GridServerCache gridServerCache = this.$cache;
                AdvancedMemoryCardMenu it = advancedMemoryCardMenu;
                boolean bl = false;
                it.setMemoryInfo(memoryInfo);
                it.setInfos(gridServerCache.retrieveP2PList());
                return advancedMemoryCardMenu;
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.examplemod.example_menu");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        });
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2COpenGui(cache.retrieveP2PList(), info2), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void removeConnection(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        playerState.remove(player.getUUID());
    }

    private static final void registerNetwork$lambda$0(Function2 $tmp0, S2COpenGui p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$1(Function2 $tmp0, S2CUpdateP2P p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$2(Function2 $tmp0, C2SLinkP2P p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$3(Function2 $tmp0, C2SCloseGui p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$4(Function2 $tmp0, C2SUpdateMemoryInfo p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$5(Function2 $tmp0, C2SRenameP2P p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$6(Function2 $tmp0, C2SRefreshP2PList p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$7(Function2 $tmp0, C2SUnlinkP2P p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$8(Function2 $tmp0, C2SChangeP2PType p0, IPayloadContext p1) {
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    static {
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        playerState = map;
    }
}

