/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lasm.betterp2p.network.data.HashHelperKt;
import dev.lasm.betterp2p.network.data.P2PLocation;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Ldev/lasm/betterp2p/network/data/P2PLocation;", "", "pos", "Lnet/minecraft/core/BlockPos;", "facing", "Lnet/minecraft/core/Direction;", "dim", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/resources/ResourceKey;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getFacing", "()Lnet/minecraft/core/Direction;", "getDim", "()Lnet/minecraft/resources/ResourceKey;", "hashCode", "", "equals", "", "other", "component1", "component2", "component3", "copy", "toString", "", "Companion", "betterp2p"})
public final class P2PLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final Direction facing;
    @NotNull
    private final ResourceKey<Level> dim;
    @NotNull
    private static final Codec<P2PLocation> CODEC;
    @NotNull
    private static final StreamCodec<ByteBuf, P2PLocation> STREAM_CODEC;

    public P2PLocation(@NotNull BlockPos pos, @NotNull Direction facing, @NotNull ResourceKey<Level> dim) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter(dim, (String)"dim");
        this.pos = pos;
        this.facing = facing;
        this.dim = dim;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final Direction getFacing() {
        return this.facing;
    }

    @NotNull
    public final ResourceKey<Level> getDim() {
        return this.dim;
    }

    public int hashCode() {
        return Long.hashCode(HashHelperKt.hashP2P(this.pos, this.facing.ordinal(), this.dim));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type dev.lasm.betterp2p.network.data.P2PLocation");
        P2PLocation cfr_ignored_0 = (P2PLocation)object2;
        if (!Intrinsics.areEqual((Object)this.pos, (Object)((P2PLocation)other).pos)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dim, ((P2PLocation)other).dim)) {
            return false;
        }
        return this.facing == ((P2PLocation)other).facing;
    }

    @NotNull
    public final BlockPos component1() {
        return this.pos;
    }

    @NotNull
    public final Direction component2() {
        return this.facing;
    }

    @NotNull
    public final ResourceKey<Level> component3() {
        return this.dim;
    }

    @NotNull
    public final P2PLocation copy(@NotNull BlockPos pos, @NotNull Direction facing, @NotNull ResourceKey<Level> dim) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter(dim, (String)"dim");
        return new P2PLocation(pos, facing, dim);
    }

    public static /* synthetic */ P2PLocation copy$default(P2PLocation p2PLocation, BlockPos blockPos, Direction direction, ResourceKey resourceKey, int n, Object object) {
        if ((n & 1) != 0) {
            blockPos = p2PLocation.pos;
        }
        if ((n & 2) != 0) {
            direction = p2PLocation.facing;
        }
        if ((n & 4) != 0) {
            resourceKey = p2PLocation.dim;
        }
        return p2PLocation.copy(blockPos, direction, resourceKey);
    }

    @NotNull
    public String toString() {
        return "P2PLocation(pos=" + this.pos + ", facing=" + this.facing + ", dim=" + this.dim + ")";
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(arg_0 -> P2PLocation.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Direction.CODEC.fieldOf("facing").forGetter(arg_0 -> P2PLocation.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dim").forGetter(arg_0 -> P2PLocation.CODEC$lambda$0$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)instance, P2PLocation::new);
    }

    private static final BlockPos CODEC$lambda$0$0(KProperty1 $tmp0, P2PLocation p0) {
        return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Direction CODEC$lambda$0$1(KProperty1 $tmp0, P2PLocation p0) {
        return (Direction)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResourceKey CODEC$lambda$0$2(KProperty1 $tmp0, P2PLocation p0) {
        return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final BlockPos STREAM_CODEC$lambda$0(KProperty1 $tmp0, P2PLocation p0) {
        return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Direction STREAM_CODEC$lambda$1(KProperty1 $tmp0, P2PLocation p0) {
        return (Direction)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ResourceKey STREAM_CODEC$lambda$2(KProperty1 $tmp0, P2PLocation p0) {
        return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Codec codec = RecordCodecBuilder.create(P2PLocation::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, arg_0 -> P2PLocation.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)Direction.STREAM_CODEC, arg_0 -> P2PLocation.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), arg_0 -> P2PLocation.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), P2PLocation::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/lasm/betterp2p/network/data/P2PLocation$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/lasm/betterp2p/network/data/P2PLocation;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "betterp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<P2PLocation> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<ByteBuf, P2PLocation> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

