/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.util;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u0005*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "getPart", "Lappeng/api/parts/IPart;", "hitResult", "Lnet/minecraft/world/phys/HitResult;", "facingPos", "Lappeng/parts/AEBasePart;", "getFacingPos", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/core/BlockPos;", "facingTile", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "betterp2p"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull BlockGetter w, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity te = w.getBlockEntity(pos);
        ICableBusContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = (ICableBusContainer)((CableBusBlockEntity)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull BlockGetter w, @NotNull BlockPos pos, @NotNull HitResult hitResult) {
        SelectedPart p;
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity te = w.getBlockEntity(pos);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart selectedPart = p = ((IPartHost)te).selectPartWorld(hitResult.getLocation());
        return selectedPart != null ? selectedPart.part : null;
    }

    @Nullable
    public static final BlockPos getFacingPos(@NotNull AEBasePart $this$facingPos) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter((Object)$this$facingPos, (String)"<this>");
        IPartHost iPartHost = $this$facingPos.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getPos()) != null) {
            Direction direction = $this$facingPos.getSide();
            if (direction == null || (direction = direction.getNormal()) == null) {
                direction = Direction.UP.getNormal();
            }
            blockPos = iPartHost.offset((Vec3i)direction);
        } else {
            blockPos = null;
        }
        return blockPos;
    }

    @Nullable
    public static final BlockEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        BlockPos pos;
        Intrinsics.checkNotNullParameter((Object)$this$facingTile, (String)"<this>");
        if ($this$facingTile.getHost().isInWorld() && (pos = CableBusUtilKt.getFacingPos($this$facingTile)) != null) {
            IPartHost iPartHost = $this$facingTile.getHost();
            return iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getLevel()) != null ? iPartHost.getBlockEntity(pos) : null;
        }
        return null;
    }
}

