/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.mfletcher.homing;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import fabric.me.mfletcher.homing.HomingConfig;
import fabric.me.mfletcher.homing.PlayerHomingData;
import fabric.me.mfletcher.homing.block.HomingBlocks;
import fabric.me.mfletcher.homing.client.HomingConfigClient;
import fabric.me.mfletcher.homing.client.KeyMappings;
import fabric.me.mfletcher.homing.client.ability.BoostAbility;
import fabric.me.mfletcher.homing.client.ability.HomingAbility;
import fabric.me.mfletcher.homing.client.animation.HomingAnimation;
import fabric.me.mfletcher.homing.item.HomingCreativeTabs;
import fabric.me.mfletcher.homing.item.HomingItems;
import fabric.me.mfletcher.homing.network.HomingMessages;
import fabric.me.mfletcher.homing.sounds.HomingSounds;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class HomingAttack {
    public static final String MOD_ID = "homing";
    public static HomingConfig config;
    public static HomingConfigClient configClient;

    public static void init() {
        HomingMessages.register();
        HomingSounds.register();
        HomingBlocks.register();
        HomingItems.register();
        HomingCreativeTabs.register();
        config = (HomingConfig)ConfigApiJava.registerAndLoadConfig(HomingConfig::new);
        configClient = (HomingConfigClient)ConfigApiJava.registerAndLoadConfig(HomingConfigClient::new, (RegisterType)RegisterType.CLIENT);
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(client -> {
                KeyMappings.register();
                HomingAnimation.register();
            });
            ClientTickEvent.CLIENT_LEVEL_POST.register(minecraft -> {
                HomingAbility.handleHoming();
                BoostAbility.handleBoost();
            });
        }
    }

    public static boolean shouldFluidCollision(class_1297 entity, class_3610 fluidState) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (HomingAttack.config.boostOnWater && PlayerHomingData.isBoosting(player) && fluidState.method_15767(class_3486.field_15517) && !player.method_6115() && !player.method_18276() && !player.method_5799() && !player.method_5681()) {
                player.method_37908().method_8406((class_2394)class_2398.field_11202, player.method_23317(), player.method_23318(), player.method_23321(), 0.0, 3.0, 0.0);
                return true;
            }
            return false;
        }
        return false;
    }
}

