/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.mfletcher.homing;

import fabric.me.mfletcher.homing.HomingAttack;
import fabric.me.mfletcher.homing.mixin.mixins.AccessorItem;
import fabric.me.mfletcher.homing.network.HomingMessages;
import fabric.me.mfletcher.homing.network.protocol.AttackS2CPacket;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PlayerHomingAttackInfo {
    private final class_3222 player;
    private final class_1297 target;
    private class_243 velocity;
    private final int startTime;
    private float prevDist;

    public PlayerHomingAttackInfo(class_3222 player, class_1297 target) {
        this.player = player;
        this.target = target;
        this.startTime = Objects.requireNonNull(player.method_5682()).method_3780();
        this.velocity = target.method_19538().method_1020(player.method_19538()).method_1029().method_1021((double)HomingAttack.config.homingSpeed);
        player.method_18799(this.velocity);
        player.field_6007 = true;
        player.field_6037 = true;
        player.method_7322(1.0f);
        this.prevDist = player.method_5739(target);
        this.sendHomingPacket(true);
    }

    public boolean tick() {
        block6: {
            block5: {
                float f;
                if (this.player.method_5829().method_1014((double)HomingAttack.config.homingHitboxAdd).method_994(this.target.method_5829().method_1014((double)HomingAttack.config.homingHitboxAdd))) break block5;
                this.prevDist = this.player.method_5739(this.target);
                if (!(this.prevDist < f) || !(this.player.method_5739(this.target) <= (float)HomingAttack.config.homingSpeed / 2.0f)) break block6;
            }
            this.attackTarget();
            this.sendHomingPacket(false);
            return false;
        }
        if (Objects.requireNonNull(this.player.method_5682()).method_3780() - this.startTime >= HomingAttack.config.homingTicksTimeout || HomingAttack.config.stopHomingOnCollision && this.player.method_37908().method_20812((class_1297)this.player, this.player.method_5829()).iterator().hasNext()) {
            this.sendHomingPacket(false);
            return false;
        }
        if (this.player.method_5682().method_3780() % 5 == 0) {
            this.velocity = this.target.method_19538().method_1020(this.player.method_19538()).method_1029().method_1021((double)HomingAttack.config.homingSpeed);
        }
        this.player.method_18799(this.velocity);
        this.player.field_6007 = true;
        this.player.field_6037 = true;
        return true;
    }

    private void attackTarget() {
        class_243 velocityNorm = this.velocity.method_1029();
        this.target.method_5643(this.player.method_37908().method_48963().method_48802((class_1657)this.player), this.getDamage());
        if (HomingAttack.config.homingTargetKnockback > 0.0f) {
            this.target.method_18800(velocityNorm.field_1352 * (double)HomingAttack.config.homingTargetKnockback, (double)(HomingAttack.config.homingTargetKnockback / 5.0f), velocityNorm.field_1350 * (double)HomingAttack.config.homingTargetKnockback);
            this.target.field_6007 = true;
        }
        class_243 newVelocity = new class_243(this.velocity.field_1352, this.velocity.field_1351, this.velocity.field_1350);
        if (HomingAttack.config.homingXZKnockbackVelocity > 0.0f) {
            newVelocity = velocityNorm.method_18805((double)(-HomingAttack.config.homingXZKnockbackVelocity), 0.0, (double)(-HomingAttack.config.homingXZKnockbackVelocity));
        }
        if (HomingAttack.config.homingYKnockbackVelocity > 0.0f) {
            newVelocity = newVelocity.method_1031(0.0, (double)(HomingAttack.config.homingYKnockbackVelocity / 2.0f), 0.0);
        }
        this.player.method_18799(newVelocity);
        this.player.field_6007 = true;
        this.player.field_6037 = true;
    }

    private float getDamage() {
        MutableFloat damage = new MutableFloat(HomingAttack.config.baseHomingDamage);
        this.player.method_5661().forEach(itemStack -> {
            class_1792 patt3829$temp = itemStack.method_7909();
            if (patt3829$temp instanceof class_1738) {
                class_1738 armorItem = (class_1738)patt3829$temp;
                damage.add((float)armorItem.method_7687() * HomingAttack.config.defenseHomingDamageMultiplier + armorItem.method_26353() * HomingAttack.config.toughnessHomingDamageMultiplier);
            }
        });
        for (Map.Entry attributeEntry : this.player.method_6047().method_7926(class_1304.field_6173).entries()) {
            class_1322 modifier = (class_1322)attributeEntry.getValue();
            if (modifier.method_6189() != AccessorItem.getBaseAttackDamageUUID()) continue;
            damage.add((Number)(modifier.method_6186() * (double)HomingAttack.config.weaponHomingDamageMultiplier));
        }
        return damage.getValue().floatValue();
    }

    private void sendHomingPacket(boolean isHoming) {
        for (class_1657 p : this.player.method_37908().method_18456()) {
            if (!(p.method_5739((class_1297)this.player) < 128.0f)) continue;
            HomingMessages.sendToPlayer(new AttackS2CPacket(this.player.method_5628(), isHoming), (class_3222)p);
        }
    }

    public String toString() {
        return this.player.method_5476() + " -> " + this.target.method_5476() + " with UUID " + this.target.method_5845();
    }

    public class_1297 getTarget() {
        return this.target;
    }
}

