/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.mfletcher.homing.mixin.mixins;

import com.mojang.authlib.GameProfile;
import fabric.me.mfletcher.homing.HomingAttack;
import fabric.me.mfletcher.homing.PlayerHomingAttackInfo;
import fabric.me.mfletcher.homing.PlayerHomingData;
import fabric.me.mfletcher.homing.mixin.access.IServerPlayerMixin;
import fabric.me.mfletcher.homing.network.HomingMessages;
import fabric.me.mfletcher.homing.network.protocol.BoostS2CPacket;
import fabric.me.mfletcher.homing.sounds.HomingSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements IServerPlayerMixin {
    @Shadow
    @Final
    private static Logger field_13975;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Unique
    @Nullable
    private PlayerHomingAttackInfo homing$playerHomingAttackInfo = null;
    @Unique
    @Nullable
    private class_1309 homing$lastHomingEntity = null;
    @Unique
    private int homing$lastHomingTicks = -1;
    @Unique
    private final class_1293 homing$speedEffect;

    @Shadow
    public abstract void method_43496(class_2561 var1);

    @Shadow
    public abstract void method_7255(int var1);

    public ServerPlayerMixin(class_1937 level, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
        this.homing$speedEffect = new class_1293(class_1294.field_5904, -1, HomingAttack.config.boostLevel, false, false, false);
    }

    @Inject(method={"setPlayerInput"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdateInput(CallbackInfo ci) {
        if (this.homing$playerHomingAttackInfo != null) {
            ci.cancel();
        }
    }

    @Override
    @Unique
    public void homing$doHoming(class_1309 entity) {
        if (entity.method_5739((class_1297)this) <= (float)HomingAttack.config.homingRange && this.homing$playerHomingAttackInfo == null) {
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)HomingSounds.HOMING.get(), class_3419.field_15248, (float)HomingAttack.config.homingVolume / 100.0f, 1.0f);
            this.homing$playerHomingAttackInfo = new PlayerHomingAttackInfo((class_3222)this, (class_1297)entity);
            this.homing$lastHomingEntity = entity;
        } else {
            field_13975.error("Homing attack failed: {}", (Object)this.homing$playerHomingAttackInfo);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)class_12972;
        if (livingEntity.equals((Object)this.homing$getHomingEntity())) {
            cir.setReturnValue((Object)false);
        }
        if (livingEntity.equals((Object)this.homing$lastHomingEntity) && this.field_13995.method_3780() <= this.homing$lastHomingTicks + HomingAttack.config.homingDamageWaitTicks) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.homing$playerHomingAttackInfo != null && !this.homing$playerHomingAttackInfo.tick()) {
            this.homing$playerHomingAttackInfo = null;
            this.homing$lastHomingTicks = this.field_13995.method_3780();
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="HEAD")})
    public void onDisconnect(CallbackInfo ci) {
        this.method_6016(this.homing$speedEffect.method_5579());
    }

    @Override
    @Unique
    public boolean homing$onTravel(class_243 movementInput) {
        if (this.homing$playerHomingAttackInfo == null) {
            if (PlayerHomingData.isBoosting(this)) {
                if (HomingAttack.config.boostHungerDrain > 0.0f) {
                    this.method_7322(HomingAttack.config.boostHungerDrain);
                }
                if (HomingAttack.config.boostXpDrain > 0) {
                    this.method_7255(-HomingAttack.config.boostXpDrain);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    @Unique
    public class_1297 homing$getHomingEntity() {
        if (this.homing$playerHomingAttackInfo != null) {
            return this.homing$playerHomingAttackInfo.getTarget();
        }
        return null;
    }

    @Override
    @Unique
    public void homing$setBoosting(boolean boosting) {
        PlayerHomingData.setBoosting(this, boosting);
        if (boosting) {
            this.method_6092(this.homing$speedEffect);
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)HomingSounds.BOOST.get(), class_3419.field_15248, (float)HomingAttack.config.boostVolume / 100.0f, 1.0f);
        } else {
            this.method_6016(this.homing$speedEffect.method_5579());
        }
        for (class_1657 p : this.method_37908().method_18456()) {
            HomingMessages.sendToPlayer(new BoostS2CPacket(this.method_5628(), boosting), (class_3222)p);
        }
    }
}

