/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import forge.me.mfletcher.homing.HomingConfig;
import forge.me.mfletcher.homing.PlayerHomingData;
import forge.me.mfletcher.homing.block.HomingBlocks;
import forge.me.mfletcher.homing.client.HomingConfigClient;
import forge.me.mfletcher.homing.client.KeyMappings;
import forge.me.mfletcher.homing.client.ability.BoostAbility;
import forge.me.mfletcher.homing.client.ability.HomingAbility;
import forge.me.mfletcher.homing.client.animation.HomingAnimation;
import forge.me.mfletcher.homing.item.HomingCreativeTabs;
import forge.me.mfletcher.homing.item.HomingItems;
import forge.me.mfletcher.homing.network.HomingMessages;
import forge.me.mfletcher.homing.sounds.HomingSounds;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class HomingAttack {
    public static final String MOD_ID = "homing";
    public static HomingConfig config;
    public static HomingConfigClient configClient;

    public static void init() {
        HomingMessages.register();
        HomingSounds.register();
        HomingBlocks.register();
        HomingItems.register();
        HomingCreativeTabs.register();
        config = (HomingConfig)ConfigApiJava.registerAndLoadConfig(HomingConfig::new);
        configClient = (HomingConfigClient)ConfigApiJava.registerAndLoadConfig(HomingConfigClient::new, (RegisterType)RegisterType.CLIENT);
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(client -> {
                KeyMappings.register();
                HomingAnimation.register();
            });
            ClientTickEvent.CLIENT_LEVEL_POST.register(minecraft -> {
                HomingAbility.handleHoming();
                BoostAbility.handleBoost();
            });
        }
    }

    public static boolean shouldFluidCollision(Entity entity, FluidState fluidState) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (HomingAttack.config.boostOnWater && PlayerHomingData.isBoosting(player) && fluidState.m_205070_(FluidTags.f_13131_) && !player.m_6117_() && !player.m_6047_() && !player.m_20069_() && !player.m_6069_()) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 3.0, 0.0);
                return true;
            }
            return false;
        }
        return false;
    }
}

