/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing;

import forge.me.mfletcher.homing.HomingAttack;
import forge.me.mfletcher.homing.mixin.mixins.AccessorItem;
import forge.me.mfletcher.homing.network.HomingMessages;
import forge.me.mfletcher.homing.network.protocol.AttackS2CPacket;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;

public class PlayerHomingAttackInfo {
    private final ServerPlayer player;
    private final Entity target;
    private Vec3 velocity;
    private final int startTime;
    private float prevDist;

    public PlayerHomingAttackInfo(ServerPlayer player, Entity target) {
        this.player = player;
        this.target = target;
        this.startTime = Objects.requireNonNull(player.m_20194_()).m_129921_();
        this.velocity = target.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_((double)HomingAttack.config.homingSpeed);
        player.m_20256_(this.velocity);
        player.f_19812_ = true;
        player.f_19864_ = true;
        player.m_36399_(1.0f);
        this.prevDist = player.m_20270_(target);
        this.sendHomingPacket(true);
    }

    public boolean tick() {
        block6: {
            block5: {
                float f;
                if (this.player.m_20191_().m_82400_((double)HomingAttack.config.homingHitboxAdd).m_82381_(this.target.m_20191_().m_82400_((double)HomingAttack.config.homingHitboxAdd))) break block5;
                this.prevDist = this.player.m_20270_(this.target);
                if (!(this.prevDist < f) || !(this.player.m_20270_(this.target) <= (float)HomingAttack.config.homingSpeed / 2.0f)) break block6;
            }
            this.attackTarget();
            this.sendHomingPacket(false);
            return false;
        }
        if (Objects.requireNonNull(this.player.m_20194_()).m_129921_() - this.startTime >= HomingAttack.config.homingTicksTimeout || HomingAttack.config.stopHomingOnCollision && this.player.m_9236_().m_186434_((Entity)this.player, this.player.m_20191_()).iterator().hasNext()) {
            this.sendHomingPacket(false);
            return false;
        }
        if (this.player.m_20194_().m_129921_() % 5 == 0) {
            this.velocity = this.target.m_20182_().m_82546_(this.player.m_20182_()).m_82541_().m_82490_((double)HomingAttack.config.homingSpeed);
        }
        this.player.m_20256_(this.velocity);
        this.player.f_19812_ = true;
        this.player.f_19864_ = true;
        return true;
    }

    private void attackTarget() {
        Vec3 velocityNorm = this.velocity.m_82541_();
        this.target.m_6469_(this.player.m_9236_().m_269111_().m_269075_((Player)this.player), this.getDamage());
        if (HomingAttack.config.homingTargetKnockback > 0.0f) {
            this.target.m_20334_(velocityNorm.f_82479_ * (double)HomingAttack.config.homingTargetKnockback, (double)(HomingAttack.config.homingTargetKnockback / 5.0f), velocityNorm.f_82481_ * (double)HomingAttack.config.homingTargetKnockback);
            this.target.f_19812_ = true;
        }
        Vec3 newVelocity = new Vec3(this.velocity.f_82479_, this.velocity.f_82480_, this.velocity.f_82481_);
        if (HomingAttack.config.homingXZKnockbackVelocity > 0.0f) {
            newVelocity = velocityNorm.m_82542_((double)(-HomingAttack.config.homingXZKnockbackVelocity), 0.0, (double)(-HomingAttack.config.homingXZKnockbackVelocity));
        }
        if (HomingAttack.config.homingYKnockbackVelocity > 0.0f) {
            newVelocity = newVelocity.m_82520_(0.0, (double)(HomingAttack.config.homingYKnockbackVelocity / 2.0f), 0.0);
        }
        this.player.m_20256_(newVelocity);
        this.player.f_19812_ = true;
        this.player.f_19864_ = true;
    }

    private float getDamage() {
        MutableFloat damage = new MutableFloat(HomingAttack.config.baseHomingDamage);
        this.player.m_6168_().forEach(itemStack -> {
            Item patt3829$temp = itemStack.m_41720_();
            if (patt3829$temp instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)patt3829$temp;
                damage.add((float)armorItem.m_40404_() * HomingAttack.config.defenseHomingDamageMultiplier + armorItem.m_40405_() * HomingAttack.config.toughnessHomingDamageMultiplier);
            }
        });
        for (Map.Entry attributeEntry : this.player.m_21205_().m_41638_(EquipmentSlot.MAINHAND).entries()) {
            AttributeModifier modifier = (AttributeModifier)attributeEntry.getValue();
            if (modifier.m_22209_() != AccessorItem.getBaseAttackDamageUUID()) continue;
            damage.add((Number)(modifier.m_22218_() * (double)HomingAttack.config.weaponHomingDamageMultiplier));
        }
        return damage.getValue().floatValue();
    }

    private void sendHomingPacket(boolean isHoming) {
        for (Player p : this.player.m_9236_().m_6907_()) {
            if (!(p.m_20270_((Entity)this.player) < 128.0f)) continue;
            HomingMessages.sendToPlayer(new AttackS2CPacket(this.player.m_19879_(), isHoming), (ServerPlayer)p);
        }
    }

    public String toString() {
        return this.player.m_5446_() + " -> " + this.target.m_5446_() + " with UUID " + this.target.m_20149_();
    }

    public Entity getTarget() {
        return this.target;
    }
}

