/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing.block;

import forge.me.mfletcher.homing.HomingAttack;
import forge.me.mfletcher.homing.block.DashBlock;
import forge.me.mfletcher.homing.network.HomingMessages;
import forge.me.mfletcher.homing.network.protocol.DashRingAnimS2CPacket;
import forge.me.mfletcher.homing.sounds.HomingSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DashRingBlock
extends DashBlock {
    private static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
    private static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);

    public DashRingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction.m_122434_() == Direction.Axis.X) {
            return X_AXIS_AABB;
        }
        return Z_AXIS_AABB;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.entityInsideDash(state, entity, HomingAttack.config.dashRingPower);
        level.m_5594_(null, pos, (SoundEvent)HomingSounds.DASH_RING.get(), SoundSource.BLOCKS, (float)HomingAttack.config.dashRingVolume / 100.0f, 1.0f);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer p : serverLevel.m_6907_()) {
                    if (!(player.m_20270_((Entity)p) <= 32.0f)) continue;
                    HomingMessages.sendToPlayer(new DashRingAnimS2CPacket(player.m_19879_()), p);
                }
            }
        }
    }
}

