/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing.mixin.mixins;

import com.mojang.authlib.GameProfile;
import forge.me.mfletcher.homing.HomingAttack;
import forge.me.mfletcher.homing.PlayerHomingAttackInfo;
import forge.me.mfletcher.homing.PlayerHomingData;
import forge.me.mfletcher.homing.mixin.access.IServerPlayerMixin;
import forge.me.mfletcher.homing.network.HomingMessages;
import forge.me.mfletcher.homing.network.protocol.BoostS2CPacket;
import forge.me.mfletcher.homing.sounds.HomingSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements IServerPlayerMixin {
    @Shadow
    @Final
    private static Logger f_8907_;
    @Shadow
    @Final
    public MinecraftServer f_8924_;
    @Unique
    @Nullable
    private PlayerHomingAttackInfo homing$playerHomingAttackInfo = null;
    @Unique
    @Nullable
    private LivingEntity homing$lastHomingEntity = null;
    @Unique
    private int homing$lastHomingTicks = -1;
    @Unique
    private final MobEffectInstance homing$speedEffect;

    @Shadow
    public abstract void m_213846_(Component var1);

    @Shadow
    public abstract void m_6756_(int var1);

    public ServerPlayerMixin(Level level, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
        this.homing$speedEffect = new MobEffectInstance(MobEffects.f_19596_, -1, HomingAttack.config.boostLevel, false, false, false);
    }

    @Inject(method={"setPlayerInput"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdateInput(CallbackInfo ci) {
        if (this.homing$playerHomingAttackInfo != null) {
            ci.cancel();
        }
    }

    @Override
    @Unique
    public void homing$doHoming(LivingEntity entity) {
        if (entity.m_20270_((Entity)this) <= (float)HomingAttack.config.homingRange && this.homing$playerHomingAttackInfo == null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)HomingSounds.HOMING.get(), SoundSource.PLAYERS, (float)HomingAttack.config.homingVolume / 100.0f, 1.0f);
            this.homing$playerHomingAttackInfo = new PlayerHomingAttackInfo((ServerPlayer)this, (Entity)entity);
            this.homing$lastHomingEntity = entity;
        } else {
            f_8907_.error("Homing attack failed: {}", (Object)this.homing$playerHomingAttackInfo);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.equals((Object)this.homing$getHomingEntity())) {
            cir.setReturnValue((Object)false);
        }
        if (livingEntity.equals((Object)this.homing$lastHomingEntity) && this.f_8924_.m_129921_() <= this.homing$lastHomingTicks + HomingAttack.config.homingDamageWaitTicks) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.homing$playerHomingAttackInfo != null && !this.homing$playerHomingAttackInfo.tick()) {
            this.homing$playerHomingAttackInfo = null;
            this.homing$lastHomingTicks = this.f_8924_.m_129921_();
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="HEAD")})
    public void onDisconnect(CallbackInfo ci) {
        this.m_21195_(this.homing$speedEffect.m_19544_());
    }

    @Override
    @Unique
    public boolean homing$onTravel(Vec3 movementInput) {
        if (this.homing$playerHomingAttackInfo == null) {
            if (PlayerHomingData.isBoosting(this)) {
                if (HomingAttack.config.boostHungerDrain > 0.0f) {
                    this.m_36399_(HomingAttack.config.boostHungerDrain);
                }
                if (HomingAttack.config.boostXpDrain > 0) {
                    this.m_6756_(-HomingAttack.config.boostXpDrain);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    @Unique
    public Entity homing$getHomingEntity() {
        if (this.homing$playerHomingAttackInfo != null) {
            return this.homing$playerHomingAttackInfo.getTarget();
        }
        return null;
    }

    @Override
    @Unique
    public void homing$setBoosting(boolean boosting) {
        PlayerHomingData.setBoosting(this, boosting);
        if (boosting) {
            this.m_7292_(this.homing$speedEffect);
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)HomingSounds.BOOST.get(), SoundSource.PLAYERS, (float)HomingAttack.config.boostVolume / 100.0f, 1.0f);
        } else {
            this.m_21195_(this.homing$speedEffect.m_19544_());
        }
        for (Player p : this.m_9236_().m_6907_()) {
            HomingMessages.sendToPlayer(new BoostS2CPacket(this.m_19879_(), boosting), (ServerPlayer)p);
        }
    }
}

