/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing.mixin.mixins.client;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import forge.me.mfletcher.homing.HomingAttack;
import forge.me.mfletcher.homing.PlayerHomingData;
import forge.me.mfletcher.homing.client.animation.HomingAnimation;
import forge.me.mfletcher.homing.mixin.access.IAbstractClientPlayerMixin;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player
implements IAbstractClientPlayerMixin {
    @Unique
    private final ModifierLayer<IAnimation> homing$animationContainer = new ModifierLayer();

    public AbstractClientPlayerMixin(Level level, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ClientLevel level, GameProfile profile, CallbackInfo ci) {
        PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)((AbstractClientPlayer)this)).addAnimLayer(1000, this.homing$animationContainer);
    }

    @Override
    @Unique
    public void homing$startHomingAnimation() {
        if (HomingAttack.configClient.showHomingAnimation) {
            HomingAnimation.playAnimation(this.homing$animationContainer, HomingAnimation.SPINDASH_ANIMATION);
        }
    }

    @Unique
    public void homing$startBoostAnimation() {
        if (HomingAttack.configClient.showBoostAnimation) {
            HomingAnimation.playAnimation(this.homing$animationContainer, HomingAnimation.BOOST_ANIMATION);
        }
    }

    @Override
    @Unique
    public void homing$stopAnimations() {
        HomingAnimation.stopAnimations(this.homing$animationContainer);
    }

    @Override
    @Unique
    public void homing$setBoosting(boolean boosting) {
        if (PlayerHomingData.isBoosting(this) != boosting) {
            if (boosting) {
                this.homing$startBoostAnimation();
            } else {
                this.homing$stopAnimations();
            }
        }
        PlayerHomingData.setBoosting(this, boosting);
    }

    @Override
    @Unique
    public ModifierLayer<IAnimation> homing$getAnimationLayer() {
        return this.homing$animationContainer;
    }
}

