/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing.mixin.mixins.client;

import com.mojang.blaze3d.platform.WindowEventHandler;
import forge.me.mfletcher.homing.HomingAttack;
import forge.me.mfletcher.homing.client.HomingConfigClient;
import forge.me.mfletcher.homing.mixin.access.IMinecraftMixin;
import forge.me.mfletcher.homing.sounds.HomingSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler,
IMinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Nullable
    public ClientLevel f_91073_;
    @Unique
    private long homing$homingReadyTime = 0L;
    @Unique
    private LivingEntity homing$highlightedEntity;
    @Unique
    private boolean homing$homingReady;

    public MinecraftMixin(String string) {
        super(string);
    }

    @Shadow
    public Entity m_91288_() {
        return null;
    }

    @Shadow
    public SoundManager m_91106_() {
        return null;
    }

    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHasOutline(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (HomingAttack.configClient.reticleType.get() == HomingConfigClient.ReticleType.GLOWING && entity.equals((Object)this.homing$getHighlightedEntity())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.f_91074_ == null || !HomingAttack.config.enableHoming) {
            return;
        }
        if (!this.f_91074_.m_5833_() && !this.f_91074_.m_20159_()) {
            if (!this.f_91074_.m_20096_()) {
                if (this.homing$isHomingReady()) {
                    LivingEntity entityLooking = this.homing$getEntityLooking();
                    if (entityLooking != null && !entityLooking.equals((Object)this.homing$getHighlightedEntity()) && HomingAttack.configClient.reticleVolume > 0) {
                        this.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)HomingSounds.RETICLE.get(), SoundSource.PLAYERS, (float)HomingAttack.configClient.reticleVolume / 100.0f, 1.0f, SoundInstance.m_235150_(), this.f_91074_.m_20183_()));
                    }
                    this.homing$setHighlightedEntity(entityLooking);
                } else {
                    this.homing$setHighlightedEntity(null);
                }
            } else {
                this.homing$setHighlightedEntity(null);
                this.homing$setHomingReady();
            }
        } else {
            this.homing$setHighlightedEntity(null);
        }
    }

    @Unique
    private LivingEntity homing$getEntityLooking() {
        if (this.f_91074_ == null || this.f_91073_ == null) {
            return null;
        }
        float homingRange = HomingAttack.config.homingRange;
        float homingAngleRange = HomingAttack.config.homingAngleRange;
        if (homingAngleRange == 0.0f) {
            LivingEntity livingEntity;
            Entity entity2;
            AABB box;
            Vec3 vec33;
            Entity camera = this.m_91288_();
            Vec3 vec32 = camera.m_20252_(1.0f);
            Vec3 vec3 = camera.m_20299_(1.0f);
            EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)camera, (Vec3)vec3, (Vec3)(vec33 = vec3.m_82520_(vec32.f_82479_ * (double)homingRange, vec32.f_82480_ * (double)homingRange, vec32.f_82481_ * (double)homingRange)), (AABB)(box = camera.m_20191_().m_82369_(vec32.m_82490_((double)homingRange)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)(homingRange * homingRange));
            if (entityHitResult != null && (entity2 = entityHitResult.m_82443_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).m_6084_() && this.f_91074_.m_142582_((Entity)livingEntity)) {
                return livingEntity;
            }
        } else {
            float playerAngle = this.f_91074_.f_20885_;
            LivingEntity closestEntity = null;
            float closestDistance = -1.0f;
            for (Entity entity3 : this.f_91073_.m_6249_((Entity)this.f_91074_, AABB.m_165882_((Vec3)this.f_91074_.m_20182_(), (double)(homingRange * 2.0f), (double)(homingRange * 2.0f), (double)(homingRange * 2.0f)), entity -> entity instanceof LivingEntity)) {
                float angle;
                float distance = entity3.m_20270_((Entity)this.f_91074_);
                if (distance > homingRange || !(Mth.m_14145_((float)((angle = this.homing$vec2Angle(entity3.m_20182_().m_82546_(this.f_91074_.m_20182_()))) - 90.0f), (float)playerAngle) < homingAngleRange) || closestEntity != null && !(distance < closestDistance) || !entity3.m_6084_() || !this.f_91074_.m_142582_(entity3)) continue;
                closestEntity = (LivingEntity)entity3;
                closestDistance = distance;
            }
            return closestEntity;
        }
        return null;
    }

    @Override
    @Unique
    public Entity homing$getHighlightedEntity() {
        return this.homing$highlightedEntity;
    }

    @Unique
    public void homing$setHighlightedEntity(LivingEntity highlightedEntity) {
        this.homing$highlightedEntity = highlightedEntity;
    }

    @Override
    @Unique
    public void homing$setHomingUnready() {
        this.homing$homingReady = false;
        this.homing$setHighlightedEntity(null);
    }

    @Override
    @Unique
    public void homing$setHomingReady() {
        this.homing$homingReady = true;
    }

    @Override
    @Unique
    public boolean homing$isHomingReady() {
        if (!this.homing$homingReady) {
            return false;
        }
        assert (this.f_91073_ != null);
        return System.currentTimeMillis() >= this.homing$homingReadyTime && this.homing$isRequiredHomingHeight();
    }

    @Override
    @Unique
    public void homing$setHomingReadyTick() {
        assert (this.f_91073_ != null);
        this.homing$homingReadyTime = System.currentTimeMillis() + (long)((int)(HomingAttack.config.homingCooldown * 1000.0f));
    }

    @Unique
    private float homing$vec2Angle(Vec3 vec3) {
        return (float)Math.toDegrees(Math.atan2(vec3.f_82481_, vec3.f_82479_));
    }

    @Unique
    private boolean homing$isRequiredHomingHeight() {
        int blockBelow;
        if (HomingAttack.config.homingMinHeight == 0.0f) {
            return true;
        }
        assert (this.f_91073_ != null);
        assert (this.f_91074_ != null);
        for (blockBelow = this.f_91074_.m_146904_() - 1; this.f_91073_.m_8055_(new BlockPos(this.f_91074_.m_146903_(), blockBelow, this.f_91074_.m_146907_())).m_60795_() && blockBelow > this.f_91073_.m_141937_(); --blockBelow) {
        }
        return this.f_91074_.m_20182_().f_82480_ - (double)blockBelow - 1.0 >= (double)HomingAttack.config.homingMinHeight;
    }
}

