/*
 * Decompiled with CFR 0.152.
 */
package forge.me.mfletcher.homing.network.protocol;

import dev.architectury.networking.NetworkManager;
import forge.me.mfletcher.homing.PlayerHomingData;
import forge.me.mfletcher.homing.mixin.access.IAbstractClientPlayerMixin;
import forge.me.mfletcher.homing.mixin.access.IMinecraftMixin;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class AttackS2CPacket {
    private final int homingPlayerId;
    private final boolean isHoming;

    public AttackS2CPacket(int homingPlayerId, boolean isHoming) {
        this.homingPlayerId = homingPlayerId;
        this.isHoming = isHoming;
    }

    public AttackS2CPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.homingPlayerId);
        buf.writeBoolean(this.isHoming);
    }

    public void apply(Supplier<NetworkManager.PacketContext> supplier) {
        NetworkManager.PacketContext context = supplier.get();
        context.queue(() -> {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Player homingPlayer = (Player)Minecraft.m_91087_().f_91073_.m_6815_(this.homingPlayerId);
            if (homingPlayer == null || Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            if (Minecraft.m_91087_().f_91074_.equals((Object)homingPlayer) && !this.isHoming) {
                ((IMinecraftMixin)Minecraft.m_91087_()).homing$setHomingReady();
                ((IMinecraftMixin)Minecraft.m_91087_()).homing$setHomingReadyTick();
            }
            PlayerHomingData.setHoming(homingPlayer, this.isHoming);
            if (this.isHoming) {
                ((IAbstractClientPlayerMixin)homingPlayer).homing$startHomingAnimation();
            } else {
                ((IAbstractClientPlayerMixin)homingPlayer).homing$stopAnimations();
            }
        });
    }
}

