/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.blocks;

import javax.annotation.Nullable;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.common.blocks.BaseFallingBlock;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.sandmastery.common.blocks.TaldainWhiteSandBlock;
import leaf.cosmere.sandmastery.common.blocks.TaldainWhiteSandLayerBlock;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlocks;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TaldainBlackSandLayerBlock
extends BaseFallingBlock {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public TaldainBlackSandLayerBlock() {
        super((BlockBehaviour.Properties)PropTypes.Blocks.SAND.get(), SoundType.f_56746_, 1.0f, 2.0f);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        switch (pType) {
            case LAND: {
                return (Integer)pState.m_61143_((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS) - 1];
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Integer)pState.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (TaldainBlackSandLayerBlock.touchesLiquid((BlockGetter)pLevel, pCurrentPos, pState)) {
            return (BlockState)this.m_49966_().m_61124_((Property)LAYERS, (Comparable)((Integer)pState.m_61143_((Property)LAYERS)));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        if (pUseContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            if (pUseContext.m_7058_()) {
                return pUseContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(pContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LAYERS});
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 3)) {
            return;
        }
        BlockState defaultWhiteSandLayers = ((TaldainWhiteSandLayerBlock)SandmasteryBlocks.TALDAIN_WHITE_SAND_LAYER.getBlock()).m_49966_();
        boolean nearbyInvestiture = MiscHelper.checkIfNearbyInvestiture(pLevel, pPos, false);
        boolean offTaldain = !MiscHelper.onTaldain((Level)pLevel);
        boolean canSeeSky = pLevel.m_45527_(pPos.m_7494_());
        if (offTaldain && !nearbyInvestiture) {
            return;
        }
        if (!canSeeSky && !nearbyInvestiture) {
            return;
        }
        if (!(MiscHelper.onTaldain((Level)pLevel) || pLevel.m_45527_(pPos.m_7494_()) || MiscHelper.checkIfNearbyInvestiture(pLevel, pPos, false))) {
            return;
        }
        pLevel.m_46597_(pPos, (BlockState)defaultWhiteSandLayers.m_61124_((Property)LAYERS, (Comparable)((Integer)pState.m_61143_((Property)LAYERS))));
        for (int i = 0; i < 4; ++i) {
            BlockPos blockpos = pPos.m_7918_(pRandom.m_188503_(3) - 1, pRandom.m_188503_(3) - 1, pRandom.m_188503_(3) - 1);
            if (!pLevel.m_8055_(blockpos).m_60713_(Blocks.f_49992_)) continue;
            pLevel.m_46597_(blockpos, ((TaldainWhiteSandBlock)SandmasteryBlocks.TALDAIN_WHITE_SAND.getBlock()).m_49966_());
        }
    }

    private static boolean touchesLiquid(BlockGetter pLevel, BlockPos pPos, BlockState state) {
        boolean touching = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (Direction direction : EnumUtils.DIRECTIONS) {
            BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(pLevel, pPos, blockstate.m_60819_(), (BlockPos)blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!state.canBeHydrated(pLevel, pPos, blockstate.m_60819_(), (BlockPos)blockpos$mutableblockpos) || blockstate.m_60783_(pLevel, pPos, direction.m_122424_())) continue;
            touching = true;
            break;
        }
        return touching;
    }
}

