/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.manifestation;

import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.sandmastery.common.capabilities.SandmasterySpiritwebSubmodule;
import leaf.cosmere.sandmastery.common.manifestation.SandmasteryManifestation;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MasteryElevate
extends SandmasteryManifestation {
    public MasteryElevate(Taldain.Mastery mastery) {
        super(mastery);
    }

    public boolean tick(ISpiritweb data) {
        boolean enabledViaHotkey = MiscHelper.enabledViaHotkey(data, 2);
        super.tick(data);
        if (this.getMode(data) > 0 && enabledViaHotkey) {
            return this.performEffectServer(data);
        }
        return false;
    }

    @Override
    public int getBaseCost() {
        return 1;
    }

    @Override
    public int getRibbonsPerLevel(ISpiritweb data) {
        return this.getMode(data) < 3 ? 3 : 1;
    }

    protected boolean performEffectServer(ISpiritweb data) {
        int maxLift;
        SandmasterySpiritwebSubmodule submodule = SandmasterySpiritwebSubmodule.get(data);
        if (this.getMode(data) < 3) {
            return false;
        }
        if (this.notEnoughChargedSand(data)) {
            return false;
        }
        LivingEntity living = data.getLiving();
        int distFromGround = MiscHelper.distanceFromGround(living);
        if (distFromGround > (maxLift = this.getMode(data) * 4)) {
            return false;
        }
        double speed = maxLift - distFromGround > 3 ? this.scaleSpeedToMode(this.getMode(data)) : 0.15;
        Vec3 direction = new Vec3(0.0, speed, 0.0);
        living.m_20256_(direction);
        living.f_19864_ = true;
        living.m_183634_();
        BlockPos groundPos = MiscHelper.blockPosAtGround(data.getLiving());
        MiscHelper.spawnMasteredSandLine((ServerLevel)data.getLiving().m_9236_(), data.getLiving().m_146892_(), new Vec3((double)groundPos.m_123341_(), (double)groundPos.m_123342_(), (double)groundPos.m_123343_()));
        submodule.adjustHydration(-this.getHydrationCost(data), true, data);
        this.useChargedSand(data);
        return true;
    }

    double scaleSpeedToMode(double mode) {
        return mode * 0.025 + 0.15;
    }
}

