/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.manifestation;

import java.util.List;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.sandmastery.common.capabilities.SandmasterySpiritwebSubmodule;
import leaf.cosmere.sandmastery.common.config.SandmasteryConfigs;
import leaf.cosmere.sandmastery.common.items.SandPouchItem;
import leaf.cosmere.sandmastery.common.manifestation.SandmasteryManifestation;
import leaf.cosmere.sandmastery.common.registries.SandmasteryItems;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class MasteryProjectile
extends SandmasteryManifestation {
    public MasteryProjectile(Taldain.Mastery mastery) {
        super(mastery);
    }

    @Override
    protected int getBaseCost() {
        return 100;
    }

    public boolean tick(ISpiritweb data) {
        SandmasterySpiritwebSubmodule submodule = SandmasterySpiritwebSubmodule.get(data);
        submodule.tickProjectileCooldown();
        if (!submodule.projectileReady()) {
            return false;
        }
        boolean enabledViaHotkey = MiscHelper.enabledViaHotkey(data, 8);
        if (this.getMode(data) > 0 && enabledViaHotkey) {
            submodule.setProjectileCooldown((Integer)SandmasteryConfigs.SERVER.PROJECTILE_COOLDOWN.get() / this.getMode(data));
            return this.performEffectServer(data);
        }
        return false;
    }

    protected boolean performEffectServer(ISpiritweb data) {
        SpiritwebCapability playerSpiritweb = (SpiritwebCapability)data;
        ServerPlayer player = (ServerPlayer)data.getLiving();
        SandmasterySpiritwebSubmodule submodule = (SandmasterySpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
        if (this.notEnoughChargedSand(data)) {
            return false;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack pouch = player.m_150109_().m_8020_(i);
            if (pouch.m_41619_() || !pouch.m_150930_((Item)SandmasteryItems.SAND_POUCH_ITEM.get())) continue;
            ((SandPouchItem)((Object)SandmasteryItems.SAND_POUCH_ITEM.get())).shoot(pouch, (Player)player);
            break;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            List pouchesFound = handler.findCurios((Item)SandmasteryItems.SAND_POUCH_ITEM.get());
            if (pouchesFound != null) {
                for (SlotResult pouchResult : pouchesFound) {
                    ItemStack pouch = pouchResult.stack();
                    if (pouch.m_41619_() || !pouch.m_150930_((Item)SandmasteryItems.SAND_POUCH_ITEM.get())) continue;
                    ((SandPouchItem)((Object)((Object)SandmasteryItems.SAND_POUCH_ITEM.get()))).shoot(pouch, (Player)player);
                    break;
                }
            }
        });
        submodule.adjustHydration(-this.getHydrationCost(data), true, data);
        this.useChargedSand(data);
        return true;
    }
}

