/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.manifestation;

import java.util.List;
import java.util.function.Predicate;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.charge.ItemChargeHelper;
import leaf.cosmere.sandmastery.common.capabilities.SandmasterySpiritwebSubmodule;
import leaf.cosmere.sandmastery.common.config.SandmasteryConfigs;
import leaf.cosmere.sandmastery.common.items.SandPouchItem;
import leaf.cosmere.sandmastery.common.registries.SandmasteryAttributes;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SandmasteryManifestation
extends Manifestation {
    protected final Taldain.Mastery mastery;

    public SandmasteryManifestation(Taldain.Mastery mastery) {
        super(Manifestations.ManifestationTypes.SANDMASTERY);
        this.mastery = mastery;
    }

    public int getPowerID() {
        return this.mastery.getID();
    }

    public int modeMin(ISpiritweb data) {
        return 0;
    }

    public int modeMax(ISpiritweb data) {
        return (int)data.getSelectedManifestation().getStrength(data, false);
    }

    public int getModeModifier(ISpiritweb data, Manifestation manifestation, int requestedModifier) {
        SpiritwebCapability playerSpiritweb = (SpiritwebCapability)data;
        SandmasterySpiritwebSubmodule submodule = (SandmasterySpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
        this.sanityCheckRibbons(data);
        if ((requestedModifier *= ((SandmasteryManifestation)manifestation).getRibbonsPerLevel(data)) > 0) {
            if (manifestation.getMode(data) >= this.modeMax(data)) {
                return 0;
            }
            return submodule.requstRibbons(data, this, requestedModifier);
        }
        if (requestedModifier < 0) {
            if (manifestation.getMode(data) <= this.modeMin(data)) {
                return 0;
            }
            return -submodule.returnRibbons(data, this, -requestedModifier);
        }
        return requestedModifier;
    }

    public void sanityCheckRibbons(ISpiritweb data) {
        int ribbons = 0;
        for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
            if (manifestation.getManifestationType() != Manifestations.ManifestationTypes.SANDMASTERY) continue;
            ribbons += data.getMode(manifestation);
        }
        SpiritwebCapability playerSpiritweb = (SpiritwebCapability)data;
        SandmasterySpiritwebSubmodule submodule = (SandmasterySpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
        if (ribbons != submodule.getUsedRibbons()) {
            submodule.setUsedRibbons(ribbons);
        }
    }

    public int getRibbonsPerLevel(ISpiritweb data) {
        return 1;
    }

    protected boolean notEnoughChargedSand(ISpiritweb data) {
        LivingEntity livingEntity = data.getLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            List<ItemStack> allPouches = this.getSandPouches(player);
            int required = this.getSandCost(data);
            if (allPouches.isEmpty()) {
                return true;
            }
            int count = 0;
            for (ItemStack stack : allPouches) {
                if ((count += StackNBTHelper.getInt((ItemStack)stack, (String)"charge_level", (int)0)) <= required) continue;
                return false;
            }
        }
        return true;
    }

    public void useChargedSand(ISpiritweb data) {
        LivingEntity livingEntity = data.getLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            List<ItemStack> allPouches = this.getSandPouches(player);
            int changeLeft = this.getSandCost(data);
            for (ItemStack stack : allPouches) {
                int startingCharge = StackNBTHelper.getInt((ItemStack)stack, (String)"charge_level", (int)0);
                int amountLeft = startingCharge - changeLeft;
                if (amountLeft >= 0) {
                    StackNBTHelper.setInt((ItemStack)stack, (String)"charge_level", (int)amountLeft);
                } else {
                    StackNBTHelper.setInt((ItemStack)stack, (String)"charge_level", (int)0);
                    changeLeft += amountLeft;
                }
                if (changeLeft > 0) continue;
                break;
            }
        }
    }

    protected List<ItemStack> getSandPouches(Player player) {
        List curios = ItemChargeHelper.getChargeCurios((Player)player);
        List items = ItemChargeHelper.getChargeItems((Player)player);
        curios.removeIf(SandmasteryManifestation.getIsItemInvalid());
        items.removeIf(SandmasteryManifestation.getIsItemInvalid());
        curios.addAll(items);
        return curios;
    }

    protected int getBaseCost() {
        return 10;
    }

    public int getSandCost(ISpiritweb data) {
        int preModifiedCost = MiscHelper.distanceFromGround(data.getLiving()) * this.getBaseCost();
        if (preModifiedCost < 0) {
            preModifiedCost = 1000000000;
        }
        return preModifiedCost * (Integer)SandmasteryConfigs.SERVER.CHARGE_COST_MULTIPLIER.get();
    }

    public int getHydrationCost(ISpiritweb data) {
        return (int)Math.round((double)this.getSandCost(data) * (Double)SandmasteryConfigs.SERVER.HYDRATION_COST_MULTIPLIER.get());
    }

    private static Predicate<ItemStack> getIsItemInvalid() {
        return obj -> !(obj.m_41720_() instanceof SandPouchItem);
    }

    public Attribute getAttribute() {
        return SandmasteryAttributes.RIBBONS.getAttribute();
    }
}

