/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.common.registration.impl.ManifestationDeferredRegister;
import leaf.cosmere.common.registration.impl.ManifestationRegistryObject;
import leaf.cosmere.sandmastery.common.manifestation.MasteryCushion;
import leaf.cosmere.sandmastery.common.manifestation.MasteryElevate;
import leaf.cosmere.sandmastery.common.manifestation.MasteryLaunch;
import leaf.cosmere.sandmastery.common.manifestation.MasteryPlatform;
import leaf.cosmere.sandmastery.common.manifestation.MasteryProjectile;
import leaf.cosmere.sandmastery.common.manifestation.SandmasteryManifestation;

public class SandmasteryManifestations {
    public static final ManifestationDeferredRegister MANIFESTATIONS = new ManifestationDeferredRegister("sandmastery");
    public static final Map<Taldain.Mastery, ManifestationRegistryObject<SandmasteryManifestation>> SANDMASTERY_POWERS = Arrays.stream(Taldain.Mastery.values()).collect(Collectors.toMap(Function.identity(), investiture -> MANIFESTATIONS.register(investiture.getName(), () -> SandmasteryManifestations.makeSandmasteryManifestation(investiture))));

    private static SandmasteryManifestation makeSandmasteryManifestation(Taldain.Mastery mastery) {
        switch (mastery) {
            case LAUNCH: {
                return new MasteryLaunch(mastery);
            }
            case ELEVATE: {
                return new MasteryElevate(mastery);
            }
            case CUSHION: {
                return new MasteryCushion(mastery);
            }
            case PROJECTILE: {
                return new MasteryProjectile(mastery);
            }
            case PLATFORM: {
                return new MasteryPlatform(mastery);
            }
        }
        return new SandmasteryManifestation(mastery);
    }
}

