/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.config;

import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SandmasteryServerConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.IntValue PROJECTILE_COOLDOWN;
    public final ForgeConfigSpec.DoubleValue HYDRATION_COST_MULTIPLIER;
    public final ForgeConfigSpec.IntValue CHARGE_COST_MULTIPLIER;
    public final ForgeConfigSpec.IntValue STARTING_HYDRATION;
    public final ForgeConfigSpec.IntValue MAX_HYDRATION;
    public final ForgeConfigSpec.IntValue OVERMASTERY_DURATION;
    public final ForgeConfigSpec.DoubleValue DEHYDRATION_THRESHOLD;
    public final ForgeConfigSpec.BooleanValue GIVE_QIDO_ON_FIRST_LOGIN;
    public final ForgeConfigSpec.IntValue QIDO_MAX_FILL;

    SandmasteryServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Sandmastery Config. This config is synced between server and client.").push("sandmastery");
        this.PROJECTILE_COOLDOWN = builder.comment("How many ticks between projectiles at 1 ribbon allocated in ticks. (1 second = 20 ticks)").defineInRange("projectileCooldown", 100, 24, 1000);
        this.HYDRATION_COST_MULTIPLIER = builder.comment("Hydration cost is tied to sand cost, how many units of hydration are used per unit of sand charge").defineInRange("hydrationCostMultiploer", 1.5, 0.5, 100.0);
        this.CHARGE_COST_MULTIPLIER = builder.comment("Charge cost multiplier is multiplied by the base cost to determine charge cost per tick").defineInRange("chargeCostMultiplier", 2, 1, 1000);
        this.STARTING_HYDRATION = builder.comment("Starting hydration a player has when they spawn into the world for the first time").defineInRange("startingHydration", 10000, 1, 100000);
        this.MAX_HYDRATION = builder.comment("Max hydration a player can have").defineInRange("maxHydration", 10000, 1, 100000);
        this.OVERMASTERY_DURATION = builder.comment("How long overmastery lasts in minutes").defineInRange("overmasteryDuration", 120, 1, 720);
        this.DEHYDRATION_THRESHOLD = builder.comment("The threshold at which a player will start to become dehydrated (percentage of max)").defineInRange("dehydrationThreshold", 0.01, 0.1, 100.0);
        this.GIVE_QIDO_ON_FIRST_LOGIN = builder.comment("Should the player be given a qido on first login?").define("qidoOnFirstLogin", false);
        this.QIDO_MAX_FILL = builder.comment("How much hydration should a qido restore in a single fill?").defineInRange("qidoMaxFill", 10000, 1, 1000000);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "SandmasteryServer";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public void clearCache() {
        this.PROJECTILE_COOLDOWN.clearCache();
        this.HYDRATION_COST_MULTIPLIER.clearCache();
        this.CHARGE_COST_MULTIPLIER.clearCache();
        this.STARTING_HYDRATION.clearCache();
        this.MAX_HYDRATION.clearCache();
        this.OVERMASTERY_DURATION.clearCache();
        this.DEHYDRATION_THRESHOLD.clearCache();
    }
}

