/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.items;

import java.util.function.Predicate;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.ChargeableItemBase;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.sandmastery.common.entities.SandProjectile;
import leaf.cosmere.sandmastery.common.items.sandpouch.SandPouchContainerMenu;
import leaf.cosmere.sandmastery.common.items.sandpouch.SandPouchInventory;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlocks;
import leaf.cosmere.sandmastery.common.registries.SandmasteryManifestations;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SandPouchItem
extends ChargeableItemBase {
    private SandPouchInventory sandPouchInventory;
    public static final Predicate<ItemStack> SUPPORTED_ITEMS = itemStack -> itemStack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND_LAYER.m_5456_() || itemStack.m_41720_() == SandmasteryBlocks.TALDAIN_WHITE_SAND_LAYER.m_5456_() || itemStack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND.m_5456_() || itemStack.m_41720_() == SandmasteryBlocks.TALDAIN_WHITE_SAND.m_5456_();

    public SandPouchItem() {
        super((Item.Properties)PropTypes.Items.ONE.get());
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        MiscHelper.chargeItemFromInvestiture(pStack, pLevel, pEntity, this.getMaxCharge(pStack));
    }

    public int getCharge(ItemStack itemStack) {
        int itemCharge = StackNBTHelper.getInt((ItemStack)itemStack, (String)"charge_level", (int)0);
        return itemCharge * itemStack.m_41613_();
    }

    public int getMaxCharge(ItemStack itemStack) {
        int res = 0;
        IItemHandlerModifiable inv = SandPouchItem.getPouchInv(itemStack);
        if (inv == null) {
            return res;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            res += MiscHelper.getChargeFromItemStack(stack);
        }
        return res;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack pouchStack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.MAIN_HAND && !player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            SimpleMenuProvider container = new SimpleMenuProvider((windowID, playerInv, plyer) -> new SandPouchContainerMenu(windowID, playerInv, pouchStack), pouchStack.m_41786_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container, buf -> buf.writeBoolean(true));
        }
        return InteractionResultHolder.m_19096_((Object)pouchStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag oldCapNbt) {
        this.sandPouchInventory = new SandPouchInventory();
        if (oldCapNbt != null) {
            this.sandPouchInventory.deserializeNBT(oldCapNbt);
        }
        return this.sandPouchInventory;
    }

    public static IItemHandlerModifiable getPouchInv(ItemStack pouchStack) {
        return (IItemHandlerModifiable)pouchStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
    }

    public void shoot(ItemStack pouch, Player player) {
        SpiritwebCapability.get((LivingEntity)player).ifPresent(data -> {
            int mode = data.getMode((Manifestation)SandmasteryManifestations.SANDMASTERY_POWERS.get(Taldain.Mastery.PROJECTILE).get());
            IItemHandlerModifiable inv = SandPouchItem.getPouchInv(pouch);
            ItemStack ammo = inv.getStackInSlot(2);
            if (ammo.m_41613_() > 0) {
                ItemStack stackToShoot = ammo.m_41777_().m_41620_(1);
                ammo.m_41774_(1);
                if (!player.m_9236_().f_46443_) {
                    SandProjectile sandProjectile = new SandProjectile(player.m_9236_(), (LivingEntity)player, stackToShoot);
                    sandProjectile.m_36762_(true);
                    sandProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    sandProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    player.m_9236_().m_7967_((Entity)sandProjectile);
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (player.m_9236_().m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
            }
        });
    }
}

