/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.items.sandpouch;

import leaf.cosmere.sandmastery.common.items.SandPouchItem;
import leaf.cosmere.sandmastery.common.items.sandpouch.SandPouchSlot;
import leaf.cosmere.sandmastery.common.registries.SandmasteryMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SandPouchContainerMenu
extends AbstractContainerMenu {
    private final ItemStack pouch;

    public static SandPouchContainerMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new SandPouchContainerMenu(windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public SandPouchContainerMenu(int windowId, Inventory playerInv, ItemStack pouch) {
        super((MenuType)SandmasteryMenuTypes.SAND_POUCH.get(), windowId);
        int j;
        int i;
        this.pouch = pouch;
        IItemHandlerModifiable pouchInv = SandPouchItem.getPouchInv(pouch);
        int invStart = 0;
        for (i = 0; i < 1; ++i) {
            for (j = 0; j < 3; ++j) {
                boolean input = i == 0 && j == 0;
                int k = j + i * 9;
                this.m_38897_((Slot)new SandPouchSlot(pouchInv, k, 8 + j * 18, 18 + i * 18, input));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 58 + (i + invStart) * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 62 + (3 + invStart) * 18));
        }
    }

    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        return itemStack;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        ItemStack main = pPlayer.m_21205_();
        ItemStack off = pPlayer.m_21206_();
        return !main.m_41619_() && main == this.pouch || !off.m_41619_() && off == this.pouch;
    }

    public void m_150399_(int slot, int dragType, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        if (slot < 0 || this.m_38853_(slot).m_7993_() != player.m_21120_(InteractionHand.MAIN_HAND)) {
            super.m_150399_(slot, dragType, clickTypeIn, player);
        }
    }
}

