/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.items.sandpouch;

import javax.annotation.Nonnull;
import leaf.cosmere.sandmastery.common.items.SandPouchItem;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class SandpouchItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected NonNullList<ItemStack> stacks;
    protected int layers;

    public SandpouchItemHandler() {
        this(1);
    }

    public SandpouchItemHandler(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 0 ? !stack.m_41619_() && SandPouchItem.SUPPORTED_ITEMS.test(stack) : false;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        ItemStack prev = (ItemStack)this.stacks.get(slot);
        int prevCount = prev.m_41619_() ? 0 : prev.m_41613_();
        int newCount = stack.m_41619_() ? 0 : stack.m_41613_();
        MODES mode = null;
        mode = prevCount < newCount ? MODES.ADD : (newCount < prevCount ? MODES.REMOVE : MODES.NO_CHANGE);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot, Math.abs(prevCount - newCount), mode);
    }

    protected void onContentsChanged(int slot) {
        this.updateSlots();
    }

    protected void onContentsChanged(int slot, int count, MODES mode) {
        ItemStack changedStack = this.getStackInSlot(slot);
        boolean sandBlock = changedStack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND.m_5456_() || changedStack.m_41720_() == SandmasteryBlocks.TALDAIN_WHITE_SAND.m_5456_();
        boolean sandLayer = changedStack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND_LAYER.m_5456_() || changedStack.m_41720_() == SandmasteryBlocks.TALDAIN_WHITE_SAND_LAYER.m_5456_();
        switch (slot) {
            case 0: {
                if (mode != MODES.ADD) break;
                if (sandBlock) {
                    this.layers += 8 * count;
                    break;
                }
                if (!sandLayer) break;
                this.layers += count;
                break;
            }
            case 1: {
                if (mode != MODES.REMOVE) break;
                this.layers -= 8 * count;
                break;
            }
            case 2: {
                if (mode != MODES.REMOVE) break;
                this.layers -= count;
            }
        }
        this.updateSlots();
    }

    private void updateSlots() {
        int numBlocks = (int)Math.floor(this.layers / 8);
        ItemStack blocksInSlot = new ItemStack(SandmasteryBlocks.TALDAIN_BLACK_SAND);
        blocksInSlot.m_41764_(Math.min(numBlocks, 64));
        ItemStack layersInSlot = new ItemStack(SandmasteryBlocks.TALDAIN_BLACK_SAND_LAYER);
        layersInSlot.m_41764_(Math.min(this.layers, 64));
        this.stacks.set(0, (Object)ItemStack.f_41583_);
        this.stacks.set(1, (Object)blocksInSlot);
        this.stacks.set(2, (Object)layersInSlot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot, existing.m_41613_(), MODES.REMOVE);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot, toExtract, MODES.REMOVE);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public CompoundTag serializeNBT() {
        this.updateSlots();
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.stacks.size());
        nbt.m_128405_("Layers", this.layers);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.setLayers(nbt.m_128441_("Layers") ? nbt.m_128451_("Layers") : 0);
        this.onLoad();
    }

    public void setSize(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    protected void onLoad() {
        this.updateSlots();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void setLayers(int layers) {
        this.layers = layers;
        this.updateSlots();
    }

    public int getLayers() {
        return this.layers;
    }

    private static enum MODES {
        ADD,
        REMOVE,
        NO_CHANGE;

    }
}

