/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.manifestation;

import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Taldain;
import leaf.cosmere.api.math.VectorHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.sandmastery.common.capabilities.SandmasterySpiritwebSubmodule;
import leaf.cosmere.sandmastery.common.manifestation.SandmasteryManifestation;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MasteryLaunch
extends SandmasteryManifestation {
    public MasteryLaunch(Taldain.Mastery mastery) {
        super(mastery);
    }

    @Override
    public int getRibbonsPerLevel(ISpiritweb data) {
        return 3;
    }

    public boolean tick(ISpiritweb data) {
        SandmasterySpiritwebSubmodule submodule = SandmasterySpiritwebSubmodule.get(data);
        submodule.tickLaunchCooldown();
        if (!submodule.launchReady()) {
            return false;
        }
        boolean enabledViaHotkey = MiscHelper.enabledViaHotkey(data, 4);
        if (this.getMode(data) > 0 && enabledViaHotkey) {
            submodule.setLaunchCooldown(10);
            return this.performEffectServer(data);
        }
        return false;
    }

    protected boolean performEffectServer(ISpiritweb data) {
        SpiritwebCapability playerSpiritweb = (SpiritwebCapability)data;
        ServerPlayer player = (ServerPlayer)data.getLiving();
        SandmasterySpiritwebSubmodule submodule = (SandmasterySpiritwebSubmodule)playerSpiritweb.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
        if (this.notEnoughChargedSand(data)) {
            return false;
        }
        int launchesAllowed = this.getMode(data) / 3;
        if (MiscHelper.distanceFromGround((LivingEntity)player) > 2) {
            if (submodule.getLaunches() >= launchesAllowed) {
                return false;
            }
            submodule.addLaunch();
            this.launch(player);
        } else {
            submodule.resetLaunches();
            this.launch(player);
        }
        BlockPos groundPos = MiscHelper.blockPosAtGround(data.getLiving());
        MiscHelper.spawnMasteredSandLine((ServerLevel)data.getLiving().m_9236_(), data.getLiving().m_146892_(), new Vec3((double)groundPos.m_123341_(), (double)groundPos.m_123342_(), (double)groundPos.m_123343_()));
        submodule.adjustHydration(-this.getHydrationCost(data), true, data);
        this.useChargedSand(data);
        return true;
    }

    protected void launch(ServerPlayer player) {
        float scaleFactor = 2.0f;
        Vec3 direction = player.m_20156_();
        Vec3 add = player.m_20184_().m_82549_(direction.m_82542_((double)scaleFactor, (double)scaleFactor, (double)scaleFactor));
        player.m_20256_(VectorHelper.ClampMagnitude((Vec3)add, (float)10.0f));
        player.f_19864_ = true;
    }
}

