/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.blocks.entities;

import leaf.cosmere.sandmastery.common.blocks.entities.SandSpreader.SandSpreaderMenu;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlockEntitiesRegistry;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlocks;
import leaf.cosmere.sandmastery.common.utils.MiscHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SandSpreaderBE
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            SandSpreaderBE.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 8;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SandSpreaderBE.this.progress;
                case 1 -> SandSpreaderBE.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SandSpreaderBE.this.progress = value;
                    break;
                }
                case 1: {
                    SandSpreaderBE.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 78;
    private int ticksSinceUpdate = 0;

    public SandSpreaderBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SandmasteryBlockEntitiesRegistry.SAND_SPREADER_BE.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Sand Spreading Tub");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SandSpreaderMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public boolean readyToUpdate() {
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            this.ticksSinceUpdate = 0;
            return true;
        }
        return false;
    }

    public boolean hasCatalyst() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack item = this.itemHandler.getStackInSlot(i);
            if (item.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND.m_5456_()) {
                return true;
            }
            if (item.m_41720_() == SandmasteryBlocks.TALDAIN_WHITE_SAND.m_5456_()) {
                return true;
            }
            if (item.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND_LAYER.m_5456_()) {
                return true;
            }
            if (item.m_41720_() != SandmasteryBlocks.TALDAIN_WHITE_SAND_LAYER.m_5456_()) continue;
            return true;
        }
        return false;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SandSpreaderBE entity) {
        if (level.m_5776_()) {
            return;
        }
        if (!entity.readyToUpdate()) {
            return;
        }
        if (!entity.hasCatalyst()) {
            return;
        }
        if (!MiscHelper.checkIfNearbyInvestiture((ServerLevel)level, pos, false)) {
            return;
        }
        ItemStackHandler inv = entity.itemHandler;
        int slot = MiscHelper.randomSlot(inv);
        ItemStack item = inv.getStackInSlot(slot);
        if (item.m_41720_() == Blocks.f_49992_.m_5456_()) {
            ItemStack newItem = new ItemStack(SandmasteryBlocks.TALDAIN_BLACK_SAND);
            newItem.m_41764_(item.m_41613_());
            inv.setStackInSlot(slot, newItem);
        }
        SandSpreaderBE.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }
}

