/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.capabilities;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.helpers.PlayerHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.sandmastery.client.SandmasteryKeybindings;
import leaf.cosmere.sandmastery.common.Sandmastery;
import leaf.cosmere.sandmastery.common.config.SandmasteryConfigs;
import leaf.cosmere.sandmastery.common.items.QidoItem;
import leaf.cosmere.sandmastery.common.manifestation.SandmasteryManifestation;
import leaf.cosmere.sandmastery.common.network.packets.SyncMasteryBindsMessage;
import leaf.cosmere.sandmastery.common.registries.SandmasteryAttributes;
import leaf.cosmere.sandmastery.common.registries.SandmasteryEffects;
import leaf.cosmere.sandmastery.common.registries.SandmasteryItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SandmasterySpiritwebSubmodule
implements ISpiritwebSubmodule {
    private CompoundTag sandmasteryTag = null;
    private int hydrationLevel;
    private int projectileCooldown;
    private int launchCooldown;
    private int launchesSinceLeftGround;
    private int numRibbonsInUse;
    private int hotkeyFlags;

    public SandmasterySpiritwebSubmodule() {
        this.hydrationLevel = (Integer)SandmasteryConfigs.SERVER.STARTING_HYDRATION.get();
        this.projectileCooldown = 0;
        this.launchCooldown = 0;
        this.launchesSinceLeftGround = 0;
        this.numRibbonsInUse = 0;
        this.hotkeyFlags = 0;
    }

    public static SandmasterySpiritwebSubmodule get(ISpiritweb data) {
        return (SandmasterySpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
    }

    public void tickClient(ISpiritweb spiritweb) {
        Manifestation manifestation = spiritweb.getSelectedManifestation();
        if (manifestation instanceof SandmasteryManifestation) {
            SandmasteryManifestation sandmasteryManifestation = (SandmasteryManifestation)manifestation;
            int isActivatedAndActive = Keybindings.MANIFESTATION_USE_ACTIVE.m_90857_() ? 1 : 0;
            int elevateFlag = SandmasteryKeybindings.SANDMASTERY_ELEVATE.m_90857_() ? 2 : 0;
            int launchFlag = SandmasteryKeybindings.SANDMASTERY_LAUNCH.m_90857_() ? 4 : 0;
            int projectileFlag = SandmasteryKeybindings.SANDMASTERY_PROJECTILE.m_90857_() ? 8 : 0;
            int platformFlag = SandmasteryKeybindings.SANDMASTERY_PLATFORM.m_90857_() ? 16 : 0;
            int currentFlags = 0;
            currentFlags += isActivatedAndActive;
            currentFlags += elevateFlag;
            currentFlags += launchFlag;
            currentFlags += projectileFlag;
            if (this.hotkeyFlags != (currentFlags += platformFlag)) {
                this.sandmasteryTag.m_128405_("hotkeys", currentFlags);
                this.hotkeyFlags = currentFlags;
                Sandmastery.packetHandler().sendToServer(new SyncMasteryBindsMessage(currentFlags));
            }
        } else if (this.hotkeyFlags != 0) {
            this.hotkeyFlags = 0;
            this.sandmasteryTag.m_128405_("hotkeys", this.hotkeyFlags);
            Sandmastery.packetHandler().sendToServer(new SyncMasteryBindsMessage(this.hotkeyFlags));
        }
    }

    public void tickServer(ISpiritweb spiritweb) {
        if ((spiritweb.getLiving().f_19797_ - 1) % 20 != 0) {
            return;
        }
        double percentage = (double)this.getHydrationLevel() / (double)((Integer)SandmasteryConfigs.SERVER.MAX_HYDRATION.get()).intValue() * 100.0;
        if (percentage <= (Double)SandmasteryConfigs.SERVER.DEHYDRATION_THRESHOLD.get()) {
            spiritweb.addEffect(EffectsHelper.getNewEffect((CosmereEffect)((CosmereEffect)SandmasteryEffects.DEHYDRATED_EFFECT.get()), (Entity)spiritweb.getLiving(), (double)1.0, (int)33));
        }
    }

    public void deserialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        this.sandmasteryTag = CompoundNBTHelper.getOrCreate((CompoundTag)compoundTag, (String)"sandmastery");
        this.hydrationLevel = this.sandmasteryTag.m_128451_("hydration_level");
        this.projectileCooldown = this.sandmasteryTag.m_128451_("projectile_cooldown");
        this.launchCooldown = this.sandmasteryTag.m_128451_("launch_cooldown");
        this.launchesSinceLeftGround = this.sandmasteryTag.m_128451_("launches_since_floor");
        this.hotkeyFlags = this.sandmasteryTag.m_128451_("hotkeys");
        this.numRibbonsInUse = this.sandmasteryTag.m_128451_("ribbons_in_use");
    }

    public void serialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        if (this.sandmasteryTag == null) {
            this.sandmasteryTag = CompoundNBTHelper.getOrCreate((CompoundTag)compoundTag, (String)"sandmastery");
        }
        this.sandmasteryTag.m_128405_("hydration_level", this.hydrationLevel);
        this.sandmasteryTag.m_128405_("projectile_cooldown", this.projectileCooldown);
        this.sandmasteryTag.m_128405_("launch_cooldown", this.launchCooldown);
        this.sandmasteryTag.m_128405_("launches_since_floor", this.launchesSinceLeftGround);
        this.sandmasteryTag.m_128405_("hotkeys", this.hotkeyFlags);
        this.sandmasteryTag.m_128405_("ribbons_in_use", this.numRibbonsInUse);
        compoundTag.m_128365_("sandmastery", (Tag)this.sandmasteryTag);
    }

    public void resetOnDeath(ISpiritweb spiritweb) {
        this.hydrationLevel = (Integer)SandmasteryConfigs.SERVER.STARTING_HYDRATION.get();
    }

    public void drainInvestiture(ISpiritweb data, double strength) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void collectMenuInfo(List<String> m_infoText) {
        String text = "Hydration: " + this.getHydrationLevel();
        m_infoText.add(text);
    }

    public void GiveStartingItem(Player player) {
        if (((Boolean)SandmasteryConfigs.SERVER.GIVE_QIDO_ON_FIRST_LOGIN.get()).booleanValue()) {
            Random r = new Random();
            ItemStack qido = ((QidoItem)SandmasteryItems.QIDO_ITEM.m_5456_()).getChargedQido(r.nextFloat());
            PlayerHelper.addItem((Player)player, (ItemStack)qido);
        }
    }

    public void GiveStartingItem(Player player, Manifestation manifestation) {
    }

    public int getHydrationLevel() {
        return this.hydrationLevel;
    }

    public void adjustHydration(int amountToAdjust, boolean allowOvermastery, ISpiritweb data) {
        int hydration = this.getHydrationLevel();
        int newHydrationValue = hydration + amountToAdjust;
        this.hydrationLevel = Mth.m_14045_((int)newHydrationValue, (int)0, (int)((Integer)SandmasteryConfigs.SERVER.MAX_HYDRATION.get()));
        if (allowOvermastery && newHydrationValue < 0) {
            SandmasterySpiritwebSubmodule.overmaster(data);
        }
    }

    public void adjustHydration(int amountToAdjust) {
        int hydration = this.hydrationLevel;
        this.hydrationLevel = Mth.m_14045_((int)(hydration + amountToAdjust), (int)0, (int)((Integer)SandmasteryConfigs.SERVER.MAX_HYDRATION.get()));
    }

    private static void overmaster(ISpiritweb data) {
        LivingEntity living = data.getLiving();
        AttributeInstance availableRibbons = living.m_21051_(SandmasteryAttributes.RIBBONS.getAttribute());
        if (availableRibbons == null) {
            return;
        }
        int ribbons = (int)availableRibbons.m_22115_();
        if (availableRibbons.m_22111_(SandmasteryAttributes.OVERMASTERY_UUID) == null) {
            int gainedRibbons = ribbons < 5 ? 3 : (ribbons < 10 ? 4 : (ribbons < 15 ? 5 : 6));
            AttributeModifier overmasteryAttributeModifier = SandmasterySpiritwebSubmodule.getOvermasteryAttributeModifier(gainedRibbons, SandmasteryAttributes.OVERMASTERY_UUID);
            availableRibbons.m_22125_(overmasteryAttributeModifier);
        } else if (availableRibbons.m_22111_(SandmasteryAttributes.OVERMASTERY_SECONDARY_UUID) == null) {
            int gainedRibbons = ribbons < 5 ? 1 : (ribbons < 10 ? 2 : (ribbons < 15 ? 3 : 4));
            AttributeModifier overmasteryAttributeModifier = SandmasterySpiritwebSubmodule.getOvermasteryAttributeModifier(gainedRibbons, SandmasteryAttributes.OVERMASTERY_SECONDARY_UUID);
            availableRibbons.m_22125_(overmasteryAttributeModifier);
        }
        living.m_6469_(living.m_269291_().m_269483_(), 10.0f);
        data.addEffect(EffectsHelper.getNewEffect((CosmereEffect)((CosmereEffect)SandmasteryEffects.OVERMASTERED_EFFECT.get()), (Entity)living, (double)1.0, (int)((Integer)SandmasteryConfigs.SERVER.OVERMASTERY_DURATION.get() * 20 * 60)));
    }

    @NotNull
    private static AttributeModifier getOvermasteryAttributeModifier(int gainedRibbons, UUID uuid) {
        AttributeModifier overmasteryAttributeModifier = new AttributeModifier(uuid, String.format("%s - gained %s ribbons: %s", "Overmastery", gainedRibbons, uuid), (double)gainedRibbons, AttributeModifier.Operation.ADDITION);
        return overmasteryAttributeModifier;
    }

    public void tickProjectileCooldown() {
        this.projectileCooldown -= this.projectileCooldown < 1 ? 0 : 1;
    }

    public void tickLaunchCooldown() {
        this.launchCooldown -= this.launchCooldown < 1 ? 0 : 1;
    }

    public void setProjectileCooldown(int cooldown) {
        this.projectileCooldown = cooldown;
    }

    public void setLaunchCooldown(int cooldown) {
        this.launchCooldown = cooldown;
    }

    public boolean projectileReady() {
        return this.projectileCooldown <= 0;
    }

    public boolean launchReady() {
        return this.launchCooldown <= 0;
    }

    public void addLaunch() {
        ++this.launchesSinceLeftGround;
    }

    public int getLaunches() {
        return this.launchesSinceLeftGround;
    }

    public void resetLaunches() {
        this.launchesSinceLeftGround = 0;
    }

    public int requstRibbons(ISpiritweb data, SandmasteryManifestation manifestation, int requestedRibbons) {
        int change = 0;
        int maxRibbons = (int)manifestation.getStrength(data, false);
        if (this.numRibbonsInUse >= maxRibbons) {
            change = 0;
            this.numRibbonsInUse = maxRibbons;
        } else {
            int changeAttempt = requestedRibbons;
            if (this.numRibbonsInUse + changeAttempt <= maxRibbons) {
                change = changeAttempt;
            }
        }
        this.numRibbonsInUse += change;
        return change;
    }

    public int returnRibbons(ISpiritweb data, SandmasteryManifestation manifestation, int returnedRibbons) {
        int newRibbons;
        int oldRibbons = this.numRibbonsInUse;
        this.numRibbonsInUse = newRibbons = Math.max(0, this.numRibbonsInUse - returnedRibbons);
        return oldRibbons - newRibbons;
    }

    public int getUsedRibbons() {
        return this.numRibbonsInUse;
    }

    public void setUsedRibbons(int ribbons) {
        this.numRibbonsInUse = ribbons;
    }

    public void debugRibbonUsage() {
        CosmereAPI.logger.info("Ribbons in use: " + this.numRibbonsInUse);
    }

    public void updateFlags(int flags) {
        this.hotkeyFlags = flags;
        this.sandmasteryTag.m_128405_("hotkeys", this.hotkeyFlags);
    }
}

