/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.items;

import javax.annotation.Nonnull;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.ChargeableItemBase;
import leaf.cosmere.common.properties.PropTypes;
import leaf.cosmere.sandmastery.common.capabilities.SandmasterySpiritwebSubmodule;
import leaf.cosmere.sandmastery.common.config.SandmasteryConfigs;
import leaf.cosmere.sandmastery.common.registries.SandmasteryAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class QidoItem
extends ChargeableItemBase {
    public QidoItem() {
        super((Item.Properties)PropTypes.Items.ONE.get());
    }

    public ItemStack getChargedQido(float fillPercent) {
        ItemStack qido = new ItemStack((ItemLike)this);
        this.setCharge(qido, Math.round(fillPercent * (float)((Integer)SandmasteryConfigs.SERVER.QIDO_MAX_FILL.get()).intValue()));
        return qido;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return (Integer)SandmasteryConfigs.SERVER.QIDO_MAX_FILL.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6047_()) {
            BlockPos pos = QidoItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.WATER).m_82425_();
            BlockState state = pLevel.m_8055_(pos);
            if (state.m_60713_(Blocks.f_49990_)) {
                pLevel.m_6263_(pPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setCharge(itemStack, this.getMaxCharge(itemStack));
            }
        } else {
            int liquid = this.getCharge(itemStack);
            if (liquid <= 0) {
                InteractionResultHolder.m_19098_((Object)itemStack);
            }
            SpiritwebCapability.get((LivingEntity)pPlayer).ifPresent(spiritweb -> {
                SpiritwebCapability data = (SpiritwebCapability)spiritweb;
                if (data.getLiving().m_21051_((Attribute)SandmasteryAttributes.RIBBONS.get()).m_22115_() < 1.0) {
                    return;
                }
                SandmasterySpiritwebSubmodule sb = SandmasterySpiritwebSubmodule.get((ISpiritweb)data);
                int playerHydration = sb.getHydrationLevel();
                int maxPlayerHydration = (Integer)SandmasteryConfigs.SERVER.MAX_HYDRATION.get();
                pPlayer.m_6672_(pUsedHand);
            });
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (!pLivingEntity.m_6047_()) {
            int availableWater = this.getCharge(pStack);
            if (availableWater == 0) {
                pLivingEntity.m_5810_();
                return;
            }
            SpiritwebCapability.get((LivingEntity)pLivingEntity).ifPresent(spiritweb -> {
                int maxPlayerHydration;
                SpiritwebCapability data = (SpiritwebCapability)spiritweb;
                SandmasterySpiritwebSubmodule sb = (SandmasterySpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.SANDMASTERY);
                int increasePerTick = Math.min(50, availableWater);
                int playerHydration = sb.getHydrationLevel();
                if (playerHydration == (maxPlayerHydration = ((Integer)SandmasteryConfigs.SERVER.MAX_HYDRATION.get()).intValue())) {
                    return;
                }
                if (increasePerTick + playerHydration > maxPlayerHydration) {
                    increasePerTick = maxPlayerHydration - playerHydration;
                }
                sb.adjustHydration(increasePerTick);
                this.setCharge(pStack, availableWater - increasePerTick);
            });
        }
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return stack.m_41793_();
    }

    public int m_8105_(ItemStack pStack) {
        return 16000;
    }
}

