/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.sandmastery.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.StackNBTHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.sandmastery.common.blocks.TemporarySandBlock;
import leaf.cosmere.sandmastery.common.registries.SandmasteryBlocks;
import leaf.cosmere.sandmastery.common.registries.SandmasteryDimensions;
import leaf.cosmere.sandmastery.common.registries.SandmasteryItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;

public class MiscHelper {
    public static boolean checkIfNearbyInvestiture(ServerLevel pLevel, BlockPos pPos, boolean includeMobs) {
        int range = 6;
        AABB areaOfEffect = new AABB(pPos).m_82377_((double)range, (double)range, (double)range);
        List entitiesToCheckForInvesiture = pLevel.m_6443_(LivingEntity.class, areaOfEffect, e -> true);
        AtomicBoolean foundSomething = new AtomicBoolean(false);
        for (LivingEntity target : entitiesToCheckForInvesiture) {
            SpiritwebCapability.get((LivingEntity)target).ifPresent(targetSpiritweb -> {
                Attribute cognitiveConcealmentAttr;
                boolean concealed = false;
                AttributeMap targetAttributes = target.m_21204_();
                if (targetAttributes.m_22171_(cognitiveConcealmentAttr = (Attribute)AttributesRegistry.COGNITIVE_CONCEALMENT.get())) {
                    concealed = targetAttributes.m_22181_(cognitiveConcealmentAttr) > 0.0;
                }
                for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                    if (concealed) {
                        foundSomething.set(false);
                        break;
                    }
                    boolean targetIsPlayer = target instanceof Player;
                    if (manifestation.getManifestationType() == Manifestations.ManifestationTypes.SANDMASTERY) continue;
                    boolean test = targetSpiritweb.hasManifestation(manifestation);
                    boolean test2 = manifestation.isActive(targetSpiritweb);
                    Manifestation test3 = manifestation;
                    if (!targetIsPlayer && targetSpiritweb.hasManifestation(manifestation) && includeMobs) {
                        foundSomething.set(true);
                        break;
                    }
                    if (!targetIsPlayer || !manifestation.isActive(targetSpiritweb)) continue;
                    foundSomething.set(true);
                    break;
                }
            });
        }
        return foundSomething.get();
    }

    public static void chargeItemFromInvestiture(ItemStack stack, Level level, Entity pEntity, int maxCharge) {
        if (level.m_5776_()) {
            return;
        }
        int currCharge = StackNBTHelper.getInt((ItemStack)stack, (String)"charge_level", (int)0);
        if (MiscHelper.checkIfNearbyInvestiture((ServerLevel)level, pEntity.m_20183_(), false)) {
            StackNBTHelper.setInt((ItemStack)stack, (String)"charge_level", (int)Mth.m_14045_((int)(currCharge + 10), (int)0, (int)maxCharge));
        }
    }

    public static boolean onTaldain(Level pLevel) {
        return pLevel.m_46472_().equals(SandmasteryDimensions.DAYSIDE_TALDAIN_DIM_KEY);
    }

    public static int distanceFromGround(LivingEntity e) {
        BlockPos pos = e.m_20183_();
        double y = pos.m_123342_();
        int dist = 0;
        for (double i = y; i >= (double)e.m_9236_().m_141937_(); i -= 1.0) {
            BlockState block = e.m_9236_().m_8055_(pos.m_7918_(0, -dist, 0));
            if (!block.m_60795_() && !block.m_60713_(SandmasteryBlocks.TEMPORARY_SAND_BLOCK.getBlock())) {
                return dist;
            }
            ++dist;
        }
        return -1;
    }

    public static BlockPos blockPosAtGround(LivingEntity e) {
        BlockPos pos = e.m_20183_();
        double y = pos.m_123342_();
        int dist = 0;
        for (double i = y; i >= (double)e.m_9236_().m_141937_(); i -= 1.0) {
            BlockState block = e.m_9236_().m_8055_(pos.m_7918_(0, -dist, 0));
            if (!block.m_60795_() && !block.m_60713_(SandmasteryBlocks.TEMPORARY_SAND_BLOCK.getBlock())) {
                return pos.m_7918_(0, -dist, 0);
            }
            ++dist;
        }
        Vec3 eyePos = e.m_146892_();
        return BlockPos.m_274446_((Position)eyePos);
    }

    public static boolean isActivatedAndActive(ISpiritweb data, Manifestation manifestation) {
        return Keybindings.MANIFESTATION_USE_ACTIVE.m_90857_() && data.getSelectedManifestation() == manifestation.getManifestation();
    }

    public static int getChargeFromItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND_LAYER.m_5456_()) {
            return stack.m_41613_() * 10;
        }
        if (stack.m_41720_() == SandmasteryBlocks.TALDAIN_BLACK_SAND.m_5456_()) {
            return stack.m_41613_() * 80;
        }
        if (stack.m_41720_() == SandmasteryItems.SAND_JAR_ITEM.m_5456_()) {
            return StackNBTHelper.getInt((ItemStack)stack, (String)"charge_level", (int)0);
        }
        return 0;
    }

    public static String intToAbbreviatedStr(int num) {
        if ((double)num < 1000.0) {
            return String.valueOf(num);
        }
        if ((double)num < 1000000.0) {
            return String.valueOf(num / 1000) + "k";
        }
        if ((double)num < 1.0E9) {
            return String.valueOf(num / 1000000) + "m";
        }
        if ((double)num < 1.0E12) {
            return String.valueOf(num / 1000000000) + "b";
        }
        return "";
    }

    public static void logToChat(ISpiritweb data, String msg) {
        LivingEntity livingEntity = data.getLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_213846_((Component)Component.m_237113_((String)msg));
        }
    }

    public static boolean isClient(ISpiritweb data) {
        return data.getLiving().m_9236_().f_46443_;
    }

    public static int getHotkeyFlags(ISpiritweb data) {
        CompoundTag dataTag = data.getCompoundTag();
        CompoundTag sandmasteryTag = CompoundNBTHelper.getOrCreate((CompoundTag)dataTag, (String)"sandmastery");
        return sandmasteryTag.m_128451_("hotkeys");
    }

    public static boolean enabledViaHotkey(ISpiritweb data, int requiredFlag) {
        int hotkeyFlags = MiscHelper.getHotkeyFlags(data);
        boolean enabledViaHotkey = false;
        if ((hotkeyFlags & requiredFlag) != 0) {
            enabledViaHotkey = true;
        }
        if ((hotkeyFlags & 1) != 0) {
            enabledViaHotkey = true;
        }
        return enabledViaHotkey;
    }

    public static int randomSlot(ItemStackHandler itemStackHandler) {
        return ThreadLocalRandom.current().nextInt(0, itemStackHandler.getSlots());
    }

    public static void spawnMasteredSandLine(ServerLevel level, Vec3 pos1, Vec3 pos2) {
        BlockParticleOption particleOptions = new BlockParticleOption(ParticleTypes.f_123814_, ((TemporarySandBlock)SandmasteryBlocks.TEMPORARY_SAND_BLOCK.getBlock()).m_49966_());
        int dist = Mth.m_14107_((double)pos1.m_82554_(pos2));
        for (Vec3 vector : MiscHelper.vectorsBetweenPositions(pos1, pos2, dist)) {
            level.m_8767_((ParticleOptions)particleOptions, vector.f_82479_, vector.f_82480_, vector.f_82481_, 2, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public static ArrayList<Vec3> vectorsBetweenPositions(Vec3 pos1, Vec3 pos2, int steps) {
        ArrayList<Vec3> array = new ArrayList<Vec3>();
        double xDist = pos1.f_82479_ - pos2.f_82479_;
        double yDist = pos1.f_82480_ - pos2.f_82480_;
        double zDist = pos1.f_82481_ - pos2.f_82481_;
        double xStepSize = xDist / (double)steps;
        double yStepSize = yDist / (double)steps;
        double zStepSize = zDist / (double)steps;
        for (int i = 0; i < steps; ++i) {
            double x = pos1.f_82479_ - xStepSize * (double)i;
            double y = pos1.f_82480_ - yStepSize * (double)i;
            double z = pos1.f_82481_ - zStepSize * (double)i;
            array.add(new Vec3(x, y, z));
        }
        return array;
    }
}

