/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.infinitesavedhotbars;

import com.google.gson.GsonBuilder;
import de.kevin_stefan.infinitesavedhotbars.InfiniteSavedHotbars;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static Config config;
    private static final Path CONFIG_FILE;
    private boolean autoScroll = false;

    private Config() {
    }

    public static Config getInstance() {
        if (config == null) {
            config = Config.load();
        }
        return config;
    }

    public boolean getAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
        this.save();
    }

    public void save() {
        try {
            Files.writeString(CONFIG_FILE, (CharSequence)new GsonBuilder().create().toJson((Object)this, Config.class), new OpenOption[0]);
        }
        catch (IOException e) {
            InfiniteSavedHotbars.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static Config load() {
        Config config = null;
        try {
            config = (Config)new GsonBuilder().create().fromJson(Files.readString(CONFIG_FILE), Config.class);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            InfiniteSavedHotbars.LOGGER.error("Failed to load config", (Throwable)e);
        }
        if (config == null) {
            return new Config();
        }
        return config;
    }

    static {
        CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("infinite-saved-hotbars.json");
    }
}

