/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.infinitesavedhotbars;

import com.mojang.serialization.DynamicOps;
import de.kevin_stefan.infinitesavedhotbars.InfiniteSavedHotbars;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4284;
import net.minecraft.class_481;
import net.minecraft.class_6903;

public class CreativeHotbars {
    private static final int VANILLA_ROWS = 9;
    private static final Path FILE = FabricLoader.getInstance().getGameDir().resolve("hotbar_extended.nbt");
    private static final ArrayList<class_1799[]> rows = new ArrayList();

    private CreativeHotbars() {
    }

    public static void init(class_481.class_483 handler) {
        for (int i = 0; i < 9; ++i) {
            handler.field_2897.add((Object)class_1802.field_8871.method_7854());
        }
        CreativeHotbars.loadFromFile();
        for (class_1799[] row : rows) {
            handler.field_2897.addAll(List.of(row));
        }
        CreativeHotbars.addEmptyRow(handler);
    }

    public static boolean onSlotClick(class_481.class_483 handler, int slot, class_1713 actionType) {
        if (slot < 81) {
            return false;
        }
        if (slot < 90) {
            return true;
        }
        if (actionType == class_1713.field_7790) {
            boolean controlPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)341);
            class_1799 cursorStack = handler.method_34255();
            class_1799 itemInSlot = (class_1799)handler.field_2897.get(slot);
            if (!controlPressed && cursorStack.method_7960()) {
                return false;
            }
            if (!(controlPressed || cursorStack.method_7960() || itemInSlot.method_7960())) {
                return true;
            }
            handler.field_2897.set(slot, (Object)cursorStack);
            CreativeHotbars.addEmptyRow(handler);
            int row = slot / 9 - 10;
            int index = slot % 9;
            CreativeHotbars.setItem(row, index, cursorStack);
            try {
                CreativeHotbars.saveToFile();
                handler.method_34254(class_1799.field_8037);
            }
            catch (IllegalStateException e) {
                InfiniteSavedHotbars.LOGGER.error("Failed to encode item", (Throwable)e);
                handler.field_2897.set(slot, (Object)itemInSlot);
            }
        }
        return true;
    }

    private static void setItem(int row, int index, class_1799 item) {
        while (rows.size() <= row) {
            class_1799[] items = new class_1799[9];
            for (int i = 0; i < 9; ++i) {
                items[i] = class_1799.field_8037;
            }
            rows.add(items);
        }
        CreativeHotbars.rows.get((int)row)[index] = item;
    }

    private static void addEmptyRow(class_481.class_483 handler) {
        int size = handler.field_2897.size();
        for (int i = size - 1; i >= size - 9; --i) {
            class_1799 item = (class_1799)handler.field_2897.get(i);
            if (item.method_7960()) continue;
            for (int j = 0; j < 9; ++j) {
                handler.field_2897.add((Object)class_1799.field_8037);
            }
            break;
        }
    }

    private static void removeEmptyRows() {
        for (int i = rows.size() - 1; i >= 0; --i) {
            class_1799[] row;
            for (class_1799 itemStack : row = rows.get(i)) {
                if (itemStack.method_7960()) continue;
                return;
            }
            rows.remove(i);
        }
    }

    private static void saveToFile() throws IllegalStateException {
        CreativeHotbars.removeEmptyRows();
        try {
            class_6903 registryOps = class_310.method_1551().field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560);
            class_2487 nbtCompound = class_2512.method_48310((class_2487)new class_2487());
            for (int i = 0; i < rows.size(); ++i) {
                class_1799[] row = rows.get(i);
                class_2499 nbtRow = new class_2499();
                for (class_1799 itemStack : row) {
                    if (itemStack.method_7960()) {
                        nbtRow.add((Object)new class_2487());
                        continue;
                    }
                    class_2520 nbtElement = (class_2520)class_1799.field_24671.encodeStart((DynamicOps)registryOps, (Object)itemStack).getOrThrow();
                    nbtRow.add((Object)nbtElement);
                }
                nbtCompound.method_10566(String.valueOf(i), (class_2520)nbtRow);
            }
            class_2507.method_10630((class_2487)nbtCompound, (Path)FILE);
        }
        catch (IOException | IllegalStateException | NullPointerException e) {
            InfiniteSavedHotbars.LOGGER.error("Failed to save extended creative slots", (Throwable)e);
        }
    }

    private static void loadFromFile() {
        try {
            class_2487 nbtCompound = class_2507.method_10633((Path)FILE);
            if (nbtCompound == null) {
                return;
            }
            int dataVersion = class_2512.method_48309((class_2487)nbtCompound, (int)3955);
            nbtCompound = class_4284.field_19215.method_48130(class_310.method_1551().method_1543(), nbtCompound, dataVersion);
            rows.clear();
            class_6903 registryOps = class_310.method_1551().field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560);
            int i = 0;
            while (nbtCompound.method_10545(String.valueOf(i))) {
                class_2499 nbtRow = (class_2499)nbtCompound.method_10580(String.valueOf(i));
                class_1799[] row = new class_1799[9];
                for (int j = 0; j < nbtRow.size(); ++j) {
                    row[j] = class_1799.field_24671.parse((DynamicOps)registryOps, (Object)nbtRow.method_10534(j)).resultOrPartial().orElse(class_1799.field_8037);
                }
                rows.add(row);
                ++i;
            }
        }
        catch (Exception e) {
            InfiniteSavedHotbars.LOGGER.error("Failed to load extended creative slots", (Throwable)e);
        }
    }
}

