---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: МЭ сундук
  icon: chest
  position: 210
categories:
- devices
item_ids:
- ae2:chest
---

# МЭ сундук

<GameScene zoom="8" background="transparent">
<ImportStructure src="../assets/blocks/chest.snbt" />
</GameScene>

MЭ сундук действует как миниатюрная сеть с <ItemLink id="terminal" />, <ItemLink id="drive" /> и <ItemLink id="energy_acceptor" />.
Хотя его можно использовать в качестве миниатюрной сети хранения данных, емкость всего одной ячейки [ячейки](../items-blocks-machines/storage_cells.md)
означает, что ее полезность как таковая ограничена.

Вместо этого он предназначен для взаимодействия именно с установленной в нем ячейкой хранения. Его встроенный терминал может видеть и получать доступ только к
к предметам в смонтированном накопителе, в то время как [устройства](../ae2-mechanics/devices.md) в общей сети могут получить доступ к предметам в любом [хранилищи сети](../ae2-mechanics/import-export-storage.md),
включая MЭ-сундуки.

Он имеет два различных графических интерфейса и имеет боковые стороны для транспортировки предметов. При взаимодействии с верхним терминалом открывается встроенный терминал. Предметы могут быть вставлены в
установленную ячейку, но не извлекать. При взаимодействии с любой другой гранью открывается графический интерфейс с указанием слота для ячейки хранения
и настройками приоритетов. Ячейка может быть вставлена и извлечена по логистике предметов только через лицо со слотом для ячейки.

Ее можно вращать с помощью <ItemLink id="certus_quartz_wrench" />.

Имеет небольшой буфер для хранения энергии AE, поэтому если не находится в сети с [энергетической ячейкой](../items-blocks-machines/energy_cells.md),
вставка или извлечение слишком большого количества предметов одновременно может привести к его отключению.

Терминал может быть окрашен с помощью <ItemLink id="color_applicator" />.

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/chest_color.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Настройки

МЭ сундук имеет все те же настройки, что и <ItemLink id="terminal" /> или <ItemLink id="crafting_terminal" />.
Однако он не поддерживает <ItemLink id="view_cell" />.

## Светодиодные индикаторы состояния ячеек

Ячейки в сундуке имеют светодиодные индикаторы, которые показывают их состояние:

| Цвет      | Статус                                                                                     |
| :-------- | :----------------------------------------------------------------------------------------- |
| Зелёный   | Пустой                                                                                     |
| Голубой   | Имеет небольшое содержание                                                                 |
| Оранжевый | [Типы](../ae2-mechanics/bytes-and-types.md) заполнены, новые типы не могут быть добавлены |
| Красный   | [Байты](../ae2-mechanics/bytes-and-types.md) заполнены, новые вещи не могут быть добалены  |
| Чёрный    | Нет энергии или дисковод не имеет [каналов](../ae2-mechanics/channels.md)                |

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса.
Объекты, входящие в сеть, будут начинаться с хранилища с наивысшим приоритетом
в качестве первого пункта назначения. В случае если два хранилища или ячейки имеют одинаковый приоритет,
то, если в одном из них уже содержится элемент, он предпочтет это хранилище любому
другому. Любые [настроенные](cell_workbench.md) ячейки будут рассматриваться как уже содержащие элемент
если они находятся в той же группе приоритетов, что и другие хранилища. Элементы, удаляемые из хранилища, будут
будут удаляться из хранилища с наименьшим приоритетом. Такая система приоритетов означает, что при вставке и удалении элементов
из сетевого хранилища, хранилища с более высоким приоритетом будут заполняться, а хранилища с более низким приоритетом - опустошаться.

## Рецепт

<RecipeFor id="chest" />
