---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Создание многоблочного процессора (хранилище, сопроцессор, монитор, блок)
  icon: 1k_crafting_storage
  position: 210
categories:
- devices
item_ids:
- ae2:1k_crafting_storage
- ae2:4k_crafting_storage
- ae2:16k_crafting_storage
- ae2:64k_crafting_storage
- ae2:256k_crafting_storage
- ae2:crafting_accelerator
- ae2:crafting_monitor
- ae2:crafting_unit
---

# Процессор создания

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/crafting_cpus.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<Row>
  <BlockImage id="1k_crafting_storage" scale="4" />

  <BlockImage id="crafting_accelerator" scale="4" />

  <BlockImage id="crafting_monitor" scale="4" />

  <BlockImage id="crafting_unit" scale="4" />
</Row>

Блок совместной обработки изготовления управляют запросами/заданиями на крафт. Они хранят промежуточные ингредиенты, пока выполняются многоэтапные задания по изготовлению предметов
и влияют на то, насколько большими могут быть задания, и в некоторой степени на скорость их выполнения. См. раздел [Автокрафт](../ae2-mechanics/autocrafting.md)
для получения более подробной информации.

Каждый процессор крафта обрабатывает один запрос или задание, поэтому, если вы хотите одновременно запросить как вычислительный процессор, так и 256 гладкого камня, вам потребуется 2 многоблока процессоров.

Их можно настроить на обработку запросов от игроков, автоматизации (шины и интерфейсы) или и того, и другого.

При щелчке правой кнопкой мыши по одному из них появляется пользовательский интерфейс статуса крафта, где вы можете отслеживать ход выполнения задания, которым занимается процессор.

## Настройки

*   Процессор может быть настроен на прием запросов только от игроков, только от автоматики (например, <ItemLink id="export_bus" /> с
    <ItemLink id="crafting_card" />) , или от обоих.

## Строительство

Крафтовые процессоры представляют собой многоблоки и должны быть твердыми прямоугольными призмами без зазоров. Они состоят из нескольких компонентов.

Каждый процессор должен содержать как минимум 1 блок крафтового хранилища (и наименее сложный работоспособный процессор, фактически, состоит всего лишь из одного 1k блока крафтового хранилища).

# Блок крафта

<BlockImage id="crafting_unit" scale="4" />

Блоки крафта просто заполняют пространство в процессоре, чтобы превратить его в сплошную прямоугольную призму, если у вас недостаточно
других компонентов. Они также являются базовым ингредиентом для других компонентов.

<RecipeFor id="crafting_unit" />

# Хранилище крафта

<Row>
  <BlockImage id="1k_crafting_storage" scale="4" />

  <BlockImage id="4k_crafting_storage" scale="4" />

  <BlockImage id="16k_crafting_storage" scale="4" />

  <BlockImage id="64k_crafting_storage" scale="4" />

  <BlockImage id="256k_crafting_storage" scale="4" />
</Row>

Хранилища крафтаф имеют все стандартные размеры ячеек (1k, 4k, 16k, 64k, 256k). В них хранятся ингредиенты и
промежуточные ингредиенты, участвующие в крафте, поэтому для обработки процессором заданий по крафту с большим количеством ингредиентов требуется большее количество хранилищ
с большим количеством ингредиентов.

<Column>
  <Row>
    <RecipeFor id="1k_crafting_storage" />
    <RecipeFor id="4k_crafting_storage" />
    <RecipeFor id="16k_crafting_storage" />
  </Row>

  <Row>
    <RecipeFor id="64k_crafting_storage" />
    <RecipeFor id="256k_crafting_storage" />
  </Row>
</Column>

# Сопроцессорный блок для крафта

<BlockImage id="crafting_accelerator" scale="4" />

Сопроцессоры для крафта заставляют систему чаще отправлять партии ингредиентов от <ItemLink id="pattern_provider" /> .
Это позволяет им не отставать от машин, выполняющих быструю обработку. В качестве примера можно привести МЭ интерфейс, окруженный
<ItemLink id="molecular_assembler" /> , способный подавать ингредиенты быстрее, чем может обработать один сборщик, и таким образом
распределяя партии ингредиентов между окружающими сборщиками.
<RecipeFor id="crafting_accelerator" />

# Монитор крафта

<BlockImage id="crafting_monitor" scale="4" />

На мониторе отображается работа, которую выполняет процессор в данный момент.
Экран можно раскрасить с помощью <ItemLink id="color_applicator" />.

<RecipeFor id="crafting_monitor" />
