---
navigation:
  title: Replication
  icon: replication:replicator
item_ids:
  - replication:replicator
  - replication:matter_network_pipe
  - replication:identification_chamber
  - replication:disintegrator
  - replication:matter_tank
  - replication:replication_terminal
  - replication:chip_storage
  - replication:replicator_enclosure
  - replication:replicator_motor
---

# Репликация

**Репликация** - то технологический мод, позволяющий воспроизводить ресурсы схожих типов. Вы можете преобразовывать землю в камень,
но не можете превратить землю в алмазы.

## Ключевые понятия

**Трубы материи** позволяют соединять механизмы репликации и автоматизировать некоторые процессы:


* Передача **энергии**: работают как обычные энергетические трубы
* Передача **материи**: tпереносят материю из **дезинтегратора** в **резервуар материи** и из **резервуара материи**
  в **другие механизмы** которые в ней нуждаются

**Камера идентификации** сканирует предметы для определения их материальных значений и сохраняет их в чипы. Эти **чипы**
могут храниться в **хранилище чипов** и будут доступны сети. Если разместить хранилище чипов поверх
камеры идентификации, шаблоны будут передаваться в Хранилище напрямую без необходимости помещать чип внутрь камеры.

**Репликаторы ** могут работать в «Бесконечном режиме», где они продолжают воспроизводить ресурс до заполнения 
или исчерпания материи. Вы можете настроить этот режим в интерфейсе.

## Как это работает

Для преобразования предметов необходимо разложить их на первичные значения с помощью **дезинтегратора**. Используя эту машину,
Вы сможете преобразовать любой предмет, обладающий материальными свойствами, в материю. После сканирования предметов и сохранения их значений
в чипы Вы сможете использовать **терминал репликации** для запроса предметов. После создания запроса **репликаторы** будут использовать
материю, хранящуюся в резервуарах, для копирования предмета с нуля и отправки его обратно на терминал.

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="setup.snbt" />
  <IsometricCamera  yaw="30" pitch="30" />
</GameScene>

## Ускорение

* Корпус репликатора: Вы можете добавить корпус к репликатору используя Shift + ПКМ по репликатору. Это
 обеспечит пассивное ускорение на 20%, но с увеличением потребления энергии на 10%.
* Мотор репликатора: Вы можете добавить мотор к репликатору используя Shift + ПКМ по репликатору. Вы сможете
  настроить множитель скорости для репликатора, где 100% — скорость по умолчанию, а 20% — максимальная скорость, на которую 
  он способен. Чем быстрее, тем выше вероятность сбоя. В случае сбоя печати репликатору придётся запуститься снова, но
  то не потребует больше материи. Чтобы создать его, Вам нужно будет создать чертеж, а затем использовать его в
  хранилище чипов, и тогда Вы сможете его скопировать.

## Материопедия

Материопедия - это поисковый список, позволяющий находить предметы с определёнными материальными значениями. Вы можете
получить доступ с помощью кнопки слева от панели поиска на экране терминала репликации, Вы также можете получить к нему доступ, 
щёлкнув по соответствующему дисплею справа от терминала.

В строке поиска Материопедии можно использовать:

* Название материи: покажет все предметы, содержащие эту материю
* `earth>10` покажет предметы с содержанием земли больше 10
* `nether=20` покажет предметы с содержанием незера ровно 20
* `quantum<6` покажет предметы с содержанием кванта меньше 6
* `!earth` покажет предметы без содержания земли
* `*metallic` покажет предметы, содержащие только металлическую материю