---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Пространственный ввод-вывод
  icon: spatial_storage_cell_2
---

# Пространственный ввод-вывод

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/spatial_storage_1x1x1.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="2 2 2">
        Объём, который будет перемещён
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Пространственный ввод-вывод — это способ вырезать и вставлять физические объёмы пространства в вашем мире. Его можно использовать для перемещения <ItemLink id="flawless_budding_quartz" />, создания комнаты в одном месте, которая меняются в любую другую по вашему желанию, или даже для перемещения портала в Энд!

Он работает путём *обмена* заданного объёма с идентичным по размеру объёмом в измерении пространственного хранения, отправляя то, что находится в массиве пилонов, в измерение пространственного хранения, а то, что находится в измерении, — в массив пилонов.

Это означает, что если у вас есть способ путешествовать между измерениями (пространственный ввод-вывод *можно* использовать для создания телепорта перемещением ячейки с вами внутри, но это очень сложно, немного криво и выходит за рамки данного руководства), вы можете использовать их как компактные машины настраиваемого размера или карманные измерения.

# Многоблочная установка

Пространственный ввод-вывод требует определённого расположения своих компонентов для работы и определения объёма, который будет вырезан и вставлен.

Все компоненты должны быть в одной [сети](me-network-connections.md), чтобы функционировать, и в одной сети может быть только одна установка пространственного ввода-вывода. Поэтому рекомендуется использовать [подсеть](subnetworks.md).

## Порт пространственного ввода-вывода

<BlockImage id="spatial_io_port" p:powered="true" scale="4" />

<ItemLink id="spatial_io_port" /> управляет операцией пространственного ввода-вывода. Он показывает статистику многоблочной установки и содержит [пространственные ячейки](../items-blocks-machines/spatial_cells.md).

Он отображает:
- Накопленную и максимальную [энергию](energy.md) в сети
- Требуемую энергию для выполнения операции. Она может быть довольно большой и используется мгновенно, так что убедитесь, что у вас достаточно [энергетических ячеек](../items-blocks-machines/energy_cells.md), чтобы вместить её всю.
- Эффективность массива пилонов
- Размер заданного объёма

Чтобы выполнить операцию пространственного ввода-вывода, поместите пространственную ячейку в слот ввода и подайте редстоун-импульс на порт пространственного ввода-вывода. Затем он *обменяет* объём в пилонах с объёмом в измерении пространственного хранения. Это означает, что если вы отправите набор блоков в измерение пространственного хранения, *затем поместите другой набор блоков в пилоны*, вставьте ячейку обратно в слот ввода и снова активируете порт ввода-вывода, второй набор блоков исчезнет, а первый набор блоков вернётся.

**БУДЬТЕ ОСТОРОЖНЫ, любая сущность в заданном объёме, включая вас, будет перенесена вместе с ним, и если у вас нет способа выбраться, вы останетесь заперты в измерении пространственного хранения, в тёмном, пустом ящике.** Попробуйте так разыграть своих друзей, им точно понравится!

## Пилоны

<BlockImage id="spatial_pylon" p:powered_on="true" scale="4" />

<ItemLink id="spatial_pylon" /> — основная часть установки пространственного ввода-вывода, определяющая объём, который будет затронут.

Объём определяется ограничивающим прямоугольником внешней стороны пилонов, уменьшенным на 1 блок во всех направлениях.

Правила таковы:
- Все пространственные пилоны должны находиться во внешнем ограничивающем прямоугольнике
- Минимальный размер ограничивающего прямоугольника 3x3x3 (что определяет объём 1x1x1)
- Все пространственные пилоны должны быть в одной сети
- Все пилоны должны быть длиной не менее 2 блоков

Например, если вы хотите определить объём 3x3x3. Согласно правилу 2, все пилоны должны находиться в оболочке 5x5x5 вокруг объёма, который вы хотите определить. Они могут быть в почти любом расположении, если содержатся в этой оболочке толщиной 1 блок размером 5x5x5.

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/spatial_storage_3x3x3_pylon_demonstration.snbt" />

<BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        Объём, который будет перемещён
  </BoxAnnotation>

<BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Более разумная конструкция выглядит так:

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/better_spatial_storage_3x3x3.snbt" />

<BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        Объём, который будет перемещён
  </BoxAnnotation>

<BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Эффективность

Эффективность массива пилонов зависит от того, насколько вы заполняете оболочку. Минимальные установки вокруг больших объёмов будут очень неэффективны и могут потребовать *миллиарды* AE.

## Размеры ячейки

После использования [пространственной ячейки](../items-blocks-machines/spatial_cells.md) она получает постоянный набор размеров XYZ (например, 3x4x2) и привязывается к объёму пространства в измерении пространственного хранения. **ВЫ НЕ МОЖЕТЕ СБРОСИТЬ, ПЕРЕФОРМАТИРОВАТЬ ИЛИ ИЗМЕНИТЬ РАЗМЕР ПРОСТРАНСТВЕННОЙ ЯЧЕЙКИ ПОСЛЕ ЕЁ ИСПОЛЬЗОВАНИЯ.** Создайте новую ячейку, если вам нужны другие размеры.

Эти размеры не совпадают с размерами в названии ячейки: ячейка 16^3 может иметь любые размеры *до* 16x16x16.

Обратите внимание, что этот объём направленный и не может быть повёрнут. Объём 2x2x3 не то же самое, что 3x2x2, хотя их размеры одинаковы.

Если размеры XYZ ячейки не совпадают с заданным объёмом (указанным в порте ввода-вывода), порт не будет работать.