---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Подсети
---

# Подсети

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/subnet_demonstration.snbt" />

<DiamondAnnotation pos="6.5 2.5 0.5" color="#00ff00">
        Предметные трубы подсети
    </DiamondAnnotation>

<DiamondAnnotation pos="5.5 2.5 0.5" color="#00ff00">
        Топливные трубы подсети
    </DiamondAnnotation>

<DiamondAnnotation pos="4.5 2.5 0.5" color="#00ff00">
       Фильтрованная плоскость уничтожения
    </DiamondAnnotation>

<DiamondAnnotation pos="3.5 2.5 0.5" color="#00ff00">
        Подсеть плоскости формирования
    </DiamondAnnotation>

<DiamondAnnotation pos="2.5 2.5 0.5" color="#00ff00">
        Подсеть, использующая взаимодействие по шине интерфейса с хранилищем, выступает в качестве локального подхранилища, к которому основная
сеть может получить доступ
    </DiamondAnnotation>

<DiamondAnnotation pos="1.5 1.5 0.5" color="#00ff00">
        Еще одна подсеть труб для возврата заряженных элементов интерфейсу
    </DiamondAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Термин "подсеть" имеет довольно свободное определение, но можно сказать, что подсеть - это любая сеть, которая поддерживает вашу 
основную сеть или выполняет какую-либо небольшую задачу. Как правило, они достаточно малы, чтобы не требовать контроллеров. Основными областями их применения являются:

*   Ограничить доступ [устройств](../ae2-mechanics/devices.md) к каким хранилищам (вы не хотите, чтобы шина импорта в подсети "трубы" имела доступ к вашему основному сетевому хранилищу)
    иначе она будет помещать предметы в ваши ячейки хранения, а не в инвентарь назначения.
*   Для экономии каналов в основной сети, например, если постащик шаблонов выводится на интерфейс, подключенный к нескольким шинам 
    шинам на нескольких машинах, используя 1 канал, вместо того, чтобы устанавливать поставщик шаблонов на каждой машине, используя несколько каналов.

Кабели разных цветов не имеют никакого отношения к созданию подсети, кроме того, что они не будут соединяться друг с другом.

Они могут быть:

*  шина импорта и шина хранения, настроенные на передачу предметов или жидкостей из одного контейнера в другой, как труба для предметов или жидкостей
*  плоскость уничтожения и шина хранения, так что единственное место, куда плоскость уничтожения может поместить то, что она разрушает, - это шина хранения, что позволяет фильтровать плоскость
*  интерфейс и плоскость формирования, так что все, что вставляется в интерфейс, выталкивается на плоскость формирования и помещается/выбрасывается в мир
*  установка для автоматического создания кварца, регулируемая и контролируемая <ItemLink id="level_emitter" /> в основной сети
*  специализированное хранилище, доступное из основной сети через специальное взаимодействие шина-интерфейс, для хранения продукции фермы без бесконечного переполнения основного хранилища
*  и так далее

Очень полезным для создания подсетей является <ItemLink id="quartz_fiber" />. Оно передает энергию между сетями, не соединяя их
что позволяет питать подсети, не расставляя повсюду приемники энергии и силовые кабели.
