---
navigation:
  parent: example-setups/example-setups-index.md
  title: Разгрузка или заполнение ячеек
  icon: io_port
---

# Разгрузка или заполнение ячеек

Возникает вопрос: "Как быстро опустошить ячейку в массив сундука, ящика или рюкзака или, наоборот, заполнить ячейку из него?".

Ответ заключается в использовании <ItemLink id="io_port" /> и некоторых подсетей для ограничения того, куда он может помещать предметы или откуда их извлекать.

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/cell_dumper_filler.snbt" />

<BoxAnnotation color="#dddddd" min="1 1 0" max="2 2 1">
        (1) Порт ввода-вывода: С помощью кнопки со стрелкой можно установить значение "Передача данных в сеть" или "Передача данных в ячейку памяти".
        в центре графического интерфейса. Имеет 3 карты ускорения.
        <ItemImage id="speed_card" scale="2" />
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 0.7 0" max="1 1 1">
        (2) Шина хранения: В конфигурации по умолчанию.
  </BoxAnnotation>

<BoxAnnotation color="#33dd33" min="0 1 0" max="1 2 1">
     Поместите сюда все, что вы хотите заполнить или опустошить.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="2 0.35 0.35" max="2.3 0.65 0.65">
        Кварцевое волокно: Необходим только в том случае, если источником энергии является другая сеть.
  </BoxAnnotation>

<DiamondAnnotation pos="3 0.5 0.5" color="#00ff00">
        К какому-либо источнику энергии, например, к другой сети или приемнику энергии.
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Конфигурации

* Для параметра <ItemLink id="io_port" /> (1) можно установить значение "Передача данных в сеть" или "Передача данных в ячейку хранения" с помощью кнопки со стрелкой
  в центре графического интерфейса. Для достижения максимальной скорости в нем предусмотрено 3 карты ускорения.
* <ItemLink id="storage_bus" /> (2) имеет конфигурацию по умолчанию.

## Как это работает

### В режиме "Передача в сеть"

1. В <ItemLink id="io_port" /> выполняется попытка сбросить содержимое вставленной [ячейки хранения](../items-blocks-machines/storage_cells.md).
    в [сетевое хранилище](../ae2-mechanics/import-export-storage.md).
2. Единственным хранилищем в подсети является <ItemLink id="storage_bus" />, в котором хранятся предметы, жидкости и т.д., 
    что бы вы ни поставили перед ним.
* <ItemLink id="energy_cell" /> обеспечивает достаточно большой буфер [энергии](../ae2-mechanics/energy.md),
    чтобы сеть не разряжалась от потребления энергии при передаче такого количества предметов за один игровой такт.

### В режиме "Передача в ячейку памяти"

1. В <ItemLink id="io_port" /> выполняется попытка сбросить содержимое [хранилища сети](../ae2-mechanics/import-export-storage.md)
   во вставленную [ячейку хранения](../items-blocks-machines/storage_cells.md).
2. Единственным хранилищем в подсети является <ItemLink id="storage_bus" />, которое извлекает предметы, жидкости и т.д. из всего,
   что бы вы ни поставили перед ним.
* <ItemLink id="energy_cell" /> обеспечивает достаточно большой буфер [энергии](../ae2-mechanics/energy.md),
  чтобы сеть не разряжалась от потребления энергии при передаче такого количества предметов за один игровой такт.