---
navigation:
  parent: example-setups/example-setups-index.md
  title: Пример "Основная сеть"
  icon: controller
---

# Пример "Основная сеть"

Во многих других конфигурациях упоминается " Основная сеть". Вы также можете спросить, как все эти [устройства](../ae2-mechanics/devices.md) объединяются
в функциональную систему. Вот пример:

<GameScene zoom="2.5" interactive={true}>
  <ImportStructure src="../assets/assemblies/treelike_network_structure.snbt" />

    <BoxAnnotation color="#dddddd" min="3.9 0 1.9" max="9.1 5 7.1" thickness="0.05">
        Большое скопление МЭ интерфейсов и сборщиков дает много места для создания шаблонов крафта, камнеобработки и кузнечного дела.
Шашечная схема позволяет интерфейсам использовать несколько сборщиков параллельно, сохраняя при этом компактность.
        Группы из 8 каналов исключают возможность неправильной маршрутизации.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="3.9 0 9.9" max="5.1 3 12.1" thickness="0.05">
        Некоторые механизмы, имеющие трубную подсеть для передачи своих выходов интерфейсам.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="-0.1 0 8.9" max="1.1 3 13.1" thickness="0.05">
      Некоторые терминалы и различные полезные приспособления (скорее всего, вам нужен только терминал крафта, а не обычный терминал.)
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="-0.1 0 -0.1" max="2.1 3 8.1" thickness="0.05">
     Массив процессоров для обработки крафта. Несколько с большим объемом памяти и несколько с меньшим объемом памяти.
Вероятно, в реальной системе необходимо иметь больше сопроцессоров, но для данной ситуации это будет слишком много.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="5.9 0 13.9" max="7.1 1 15.1" thickness="0.05">
      Контроллер должен находиться в середине основания и, возможно, немного превышать его. Форма в виде палки вполне подходит.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="11.9 0 7.9" max="13.1 4 13.1" thickness="0.05">
       Различные способы хранения данных, с помощью накопителей или шин хранения. Обратите внимание, что все они объединены в группы по 8 штук.
    </BoxAnnotation>

    <BoxAnnotation color="#dddddd" min="10.9 0 0.9" max="13.1 2 7.1" thickness="0.05">
        Различные способы хранения данных, с помощью накопителей или шин хранения. Обратите внимание, что все они объединены в группы по 8 штук.
    </BoxAnnotation>

  <IsometricCamera yaw="315" pitch="30" />
</GameScene>
