---
navigation:
  parent: example-setups/example-setups-index.md
  title: Предметные/жидкостные трубы подсети
  icon: storage_bus
---

# Предметные/жидкостные трубы подсети

Простой метод моделирования предметных и/или жидкостных труб с помощью AE2 [устройств](../ae2-mechanics/devices.md), полезный, в общем, для всего, где их можно использовать.
В том числе и для возврата результата работы в <ItemLink id="pattern_provider" />.

Обычно это можно сделать двумя различными способами:

## Шина импорта -> Шина хранения

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/import_storage_pipe.snbt" />

<BoxAnnotation color="#dddddd" min="3.7 0 0" max="4 1 1">
        (1) Шина импорта: Может быть отфильтрована.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 1">
        (2) Шина хранения: Может быть отфильтрована. Эта (и другие шины хранения, которые вы хотите использовать в качестве назначения)
        должны быть единственным хранилищем в сети.
  </BoxAnnotation>

<DiamondAnnotation pos="4.5 0.5 0.5" color="#00ff00">
        Источник
    </DiamondAnnotation>

<DiamondAnnotation pos="0.5 0.5 0.5" color="#00ff00">
        Назначение
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

<ItemLink id="import_bus" /> (1) на исходном инвентаре импортирует предметы или жидкость и пытается сохранить их в [хранилище сети](../ae2-mechanics/import-export-storage.md).
Поскольку единственным хранилищем в сети является <ItemLink id="storage_bus" /> (2) (вот почему это подсеть, а не основная сеть), предметы или жидкость
помещаются в инвентарь назначения и таким образом передаются. Энергия подается через <ItemLink id="quartz_fiber" />.
Как шину импорта, так и шину хранения можно фильтровать, но при отсутствии фильтров установка будет передавать все, к чему она может получить доступ.
Эта установка также работает с несколькими шинами импорта и несколькими шинами хранения.

## Шина хранения -> Шина экспорта

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/storage_export_pipe.snbt" />

<BoxAnnotation color="#dddddd" min="3.7 0 0" max="4 1 1">
        (1) Шина хранения: Может быть отфильтрована. Эта (и другие шины хранения, которые вы хотите использовать в качестве источника)
        должны быть единственным хранилищем в сети.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 0 0" max="1.3 1 1">
        (2) Шина экспорта: Должна быть отфильтрована.
  </BoxAnnotation>

<DiamondAnnotation pos="4.5 0.5 0.5" color="#00ff00">
        Источник
    </DiamondAnnotation>

<DiamondAnnotation pos="0.5 0.5 0.5" color="#00ff00">
        Назначение
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Устройство <ItemLink id="export_bus" /> в инвентаре назначения пытается извлечь предметы в свой фильтр из [хранилища сети](../ae2-mechanics/import-export-storage.md).
Поскольку единственным хранилищем в сети является <ItemLink id="storage_bus" /> (вот почему это подсеть, а не основная сеть), элементы или жидкость
извлекаются из исходного хранилища и таким образом передаются. Энергия поступает через шину <ItemLink id="quartz_fiber" />.
Поскольку для работы шины экспорта должны быть отфильтрованы, данная установка работает только при условии фильтрации шины экспорта.
Эта схема также работает с несколькими шинами хранения и несколькими шинами экспорта.

## Неработающая установка (шина импорта -> шина экспорта)

<GameScene zoom="6" background="transparent">
  <ImportStructure src="../assets/assemblies/import_export_pipe.snbt" />

<BoxAnnotation color="#dd3333" min="3.7 0 0" max="4 1 1">
        Шина импорта: Поскольку в сети нет хранилища, то и импортировать некуда.
  </BoxAnnotation>

<BoxAnnotation color="#dd3333" min="1 0 0" max="1.3 1 1">
        (2) Шина экспорта: Поскольку у сети нет хранилища, ей нечего экспортировать.
  </BoxAnnotation>

<DiamondAnnotation pos="4.5 0.5 0.5" color="#ff0000">
        Источник
    </DiamondAnnotation>

<DiamondAnnotation pos="0.5 0.5 0.5" color="#ff0000">
        Назначение
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Установка с использованием только шины импорта и экспорта не будет работать. Шина импорта будет пытаться извлечь из исходного инвентаря
и сохранить элементы или жидкость в сетевом хранилище. Шина экспорта будет пытаться извлечь из сетевого хранилища и поместить
предметы или жидкость в целевой инвентарь. Однако поскольку в этой сети **нет хранилища**, шина импорта не может импортировать
а шина экспорта не может экспортировать, поэтому ничего не происходит.

## Подсеть, похожая на трубу

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/furnace_automation.snbt" />

<BoxAnnotation color="#dddddd" min="1 1 0" max="2 1.3 1">
        Интерфейс: Поскольку он не настроен на хранение чего-либо на складе, он пытается сбросить все, что находится в его инвентарных слотах
        в сетевое хранилище.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="1 1 0" max="1.3 2 1">
        Шина хранения: "Сетевое хранилище" для интерфейса, в которое будет производиться сброс. Может быть отфильтрован.
  </BoxAnnotation>

<BoxAnnotation color="#dddddd" min="0 2 0" max="1 2.3 1">
        Шина хранения: "Сетевое хранилище" для интерфейса, в которое будет производиться сброс. Может быть отфильтрован.
  </BoxAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Оказывается, кроме шин импорта существуют [устройства](../ae2-mechanics/devices.md), которые перебрасывают элементы в [хранилище сети](../ae2-mechanics/import-export-storage.md)!
Здесь имеет значение <ItemLink id="interface" />. Если вставляется элемент, для которого интерфейс не установлен на складе, то интерфейс
переместит его в сетевое хранилище, что мы можем использовать аналогично шине импорта -> шине хранения. Эта настройка
особенно полезна при использовании <ItemLink id="pattern_provider" />, поскольку шина импорта не может извлечь из нее ингредиенты рецепта. Просто убедитесь, 
что интерфейс находится в режиме направленного или плоского подраздела, поэтому они не образуют сетевого
соединения.
