---
navigation:
  parent: example-setups/example-setups-index.md
  title: Авторегулируемый генератор булыжника
  icon: minecraft:cobblestone
---

# Авторегулируемый генератор булыжника

Автоматизировать генератор булыжников очень просто, достаточно вставить <ItemLink id="annihilation_plane" /> в стандартный ванильный
ручной генератор булыжника. Однако, в конечном счете, это приведет к тому, что ваша сеть будет забита булыжниками, поэтому необходимо некоторое регулирование.

Из-за особенностей работы плоскостей уничтожения (они действуют как <ItemLink id="import_bus" />), мы не можем просто поставить <ItemLink id="level_emitter" />
напротив <ItemLink id="export_bus" /> с <ItemLink id="redstone_card" /> (поскольку нельзя напрямую перейти от импорта к экспорту
без промежуточного хранилища). Приходится действовать более окольными путями.

<ItemLink id="toggle_bus" /> позволяют соединять и разъединять части сети с помощью сигналов редстоуна, но при этом они вызывают
перезагрузку сети при каждом таком действии. Существует простой обходной путь: поместите шину переключения в [подсети](../ae2-mechanics/subnetworks.md)
так, чтобы она перезагружала только подсеть.

Мы можем иметь автономные <ItemLink id="annihilation_plane" /> и <ItemLink id="storage_bus" /> [подсети](../ae2-mechanics/subnetworks.md)
поставка осуществляется в <ItemLink id="interface" /> основной сети. Шина переключения будет подключать и отключать подсеть от
<ItemLink id="quartz_fiber" />, отключая питание плоскостей.

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/regulated_cobble_gen.snbt" />

<BoxAnnotation color="#dddddd" min="3 2 2" max="7 2.3 3">
        (1) Плоскости уничтожения: Не имеют графического интерфейса для настройки, но могут быть зачарованы на Эффективность и Разрушение для снижения энергопотребления.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2 2 2" max="2.3 3 3">
        (2) Шина хранения: В конфигурации по умолчанию.
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 2.3 2" max="2.7 2.7 2.3">
        (3) Шина переключения: Очень важно, чтобы шина переключения находилась в
        подсети, а не в основной сети..
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="2.3 3 2.3" max="2.7 3.3 2.7">
        (4) Излучатель уровня: Сконфигурирован с булыжником и необходимым количеством, установлен в положение "Излучать, когда уровень ниже предела".
  </BoxAnnotation>

  <BoxAnnotation color="#dddddd" min="1 2 3" max="2 3 2">
        (5) Интерфейс: В конфигурации по умолчанию.
  </BoxAnnotation>

<DiamondAnnotation pos="0 2.5 1.5" color="#00ff00">
        К основной сети
    </DiamondAnnotation>

<DiamondAnnotation pos="5 1.5 3.5" color="#00ff00">
        Обводненные ступени не дают воде стекать и превращать лаву в обсидиан.
    </DiamondAnnotation>

  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Конфигурации

* <ItemLink id="annihilation_plane" /> (1) не имеет графического интерфейса для настройки, но может быть зачарован на эффективность и разрушение для снижения энергопотребления.
* <ItemLink id="storage_bus" /> (2) имеет конфигурацию по умолчанию.
* <ItemLink id="toggle_bus" /> (3) должна находиться на стороне подсети кварцевого волокна, а не на стороне основной сети,
  иначе основная сеть будет перезагружаться при каждом переключении.
* <ItemLink id="level_emitter" /> (4) конфигурируется с нужным элементом и количеством, и устанавливается в положение "Излучать, когда уровень ниже предела".
* <ItemLink id="interface" /> (5) имеет конфигурацию по умолчанию.

## Как это работает

1. Генератор булыжника производит некоторое количество булыжника.
2. <ItemLink id="annihilation_plane" /> разбивают булыжник. 
3. <ItemLink id="storage_bus" /> сохраняет булыжник в устройстве <ItemLink id="interface" />, отправляя его в основную сеть.
4. Когда количество булыжника в основной сети превысит заданное, <ItemLink id="level_emitter" /> перестанет
   посылать сигнал, выключая <ItemLink id="toggle_bus" />.
5. Это отключает питание подсети, прекращая работу плоскостей уничтожения.