---
navigation:
  parent: example-setups/example-setups-index.md
  title: Типы хранилищ и порядок в сети
  icon: drive
---

# Различные виды хранилищ и поддержание порядка в сети

Используя фильтры, [разбивку секторов](../items-blocks-machines/cell_workbench.md) и [приоритет хранилища](../ae2-mechanics/import-export-storage.md#приоритет-хранения),
вы можете настроить несколько уровней хранилищ для разных типов вещей.

Типы хранилищ обычно бывают:
* Общее хранилище, для всех случайных вещей, которых у вас от нескольких до нескольких тысяч. Используются небольшие [ячейки](../items-blocks-machines/storage_cells.md),
  например, на 4К или 16К.
* Массовое хранилище, для всего, чего у вас больше нескольких тысяч, например, булыжника или железа. Используются большие ячейки, как 256К,
  или ячейки из аддона MEGA.
* Локальное хранилище на фермах, как описано в [Специализированное локальное хранилище](specialized-local-storage.md) и
  [различных](simple-certus-farm.md) [фермах](semiauto-certus-farm.md) [истинного кварца](advanced-certus-farm.md) (это разные ссылки).

Приоритеты настроены так, что когда предметы поступают в основную сеть, они сначала пытаются попасть в специализированное
массовое или локальное хранилище, и если это невозможно (из-за фильтров и разбития на секторы), они помещаются в общее хранилище.
Это означает, что предметы НЕ БУДУТ АКТИВНО ПЕРЕМЕЩАТЬСЯ из одного хранилища в другое, но будут «мигрировать» по мере входа и выхода из сети.
Для активного перемещения предметов используйте <ItemLink id="io_port" />.

<GameScene zoom="3" interactive={true}>
  <ImportStructure src="../assets/assemblies/network_storage_types.snbt" />

    <BoxAnnotation color="#33dd33" min="11 0 1" max="12 1.3 2" thickness="0.05">
        Массовое хранилище. В данном случае отфильтрованная шина хранения на хранилище большой ёмкости, например, ящик из Storage Drawers. Эта шина хранения отфильтрована на уголь. 
        Она имеет высокий приоритет, поэтому, когда уголь поступает в сеть, он отправляется к этой шине хранения, а когда уголь извлекается из сети,
        он извлекается *отовсюду, кроме этого места*, так что уголь «мигрирует» в этот ящик (Storage Drawers).

        ВАЖНОЕ ПРИМЕЧАНИЕ: Большие оптимизированные инвентари, как ящики Storage Drawers, хороши, но большие *не*оптимизированные инвентари с множеством слотов, например,
		колоссальные сундуки, ужасны для производительности при использовании с шинами хранения.
    </BoxAnnotation>

    <BoxAnnotation color="#33dd33" min="11 0 3" max="12 1 4" thickness="0.05">
        Массовое хранилище. В данном случае разбитая 256К ячейка в стойке с высоким приоритетом. Эта ячейка разбита на секторы с
        булыжником и железом. Она имеет карту равного распределения, чтобы не заполниться полностью булыжником, не оставив места для железа.
        Стойка имеет высокий приоритет, поэтому, когда булыжник или железо поступает в сеть, они отправляются к этой шине хранения,
        а когда булыжник или железо извлекается из сети, они извлекаются *отовсюду, кроме этого места*, так что булыжник и железо «мигрируют» в эту ячейку.
    </BoxAnnotation>

    <BoxAnnotation color="#33dddd" min="11 0 5" max="12 1 6" thickness="0.05">
        Общее хранилище. В данном случае стойка, полная 16К ячеек. Эти ячейки не разбиты на секторы. Стойка имеет нейтральный приоритет
        (в данном случае 0), поэтому, когда что-то поступает в сеть, оно сначала отправляется в специализированное массовое или локальное хранилище,
        а когда что-то извлекается из сети, оно извлекается отсюда в первую очередь, так что предметы, имеющие специализированное хранилище, естественно
        «мигрируют» из общего хранилища.
    </BoxAnnotation>

    <BoxAnnotation color="#88ff88" min="11 0 8" max="12 1 9" thickness="0.05">
        Этот порт ввода-вывода играет важную роль в поддержании порядка в сети. Поскольку приоритет хранилища не *активно*
        перемещает предметы, ячейки, используемые в общем хранилище, и следует периодически «перемешивать» их через порт ввода-вывода,
        чтобы переместить предметы в выделенное для них место в специализированном хранилище. Это «дефрагментирует» хранилище,
        гарантируя, что вещи не хранятся в нескольких местах.
    </BoxAnnotation>

    <BoxAnnotation color="#dd3333" min="14 0 11" max="15 1 12" thickness="0.05">
        Локальное хранилище на ферме мобов. В эту стойку вставлены ячейки, разбитые на добычу с мобов, который вы хотите сохранить, например, кости и стрелы.
        Сама стойка не имеет приоритета, потому что приоритет влияет на шину хранения, которая обращается к подсети с основной сети.
        Ячейки имеют карты равного распределения и карты уничтожения излишков.
    </BoxAnnotation>

    <BoxAnnotation color="#dd3333" min="14 1 10" max="15 2.3 11" thickness="0.05">
        Локальное хранилище на ферме мобов. Эта установка шина хранения — интерфейс позволяет основной сети получить доступ к хранилищу этой подсети.
        Шина хранения имеет высокий приоритет и отфильтрована на вещи, хранимые в ячейках подсети.

        ВАЖНО: Из-за настройки с мусорным баком в подсети убедитесь, что эта шина хранения отфильтрована, иначе она начнёт уничтожать
        *каждый предмет, жидкость и т.д., поступающие в сеть*!
    </BoxAnnotation>

    <BoxAnnotation color="#dd3333" min="14 0 9" max="15 1.3 10" thickness="0.05">
        Локальное хранилище на ферме мобов. Эта шина хранения на конденсаторе материи имеет более низкий приоритет, чем стойка. Это означает,
        что добыча с мобов, которая не может попасть в ячейки стойки, будет перемещаться сюда и уничтожаться. Это важно,
        чтобы подсеть не заполнялась случайным хламом, например, повреждёнными луками.
    </BoxAnnotation>

    <BoxAnnotation color="#dd33dd" min="8 1 11.7" max="9 2.3 13" thickness="0.05">
        Локальное хранилище на ферме арбузов. Эта установка использует метод, аналогичный примерам ферм истинного кварца. Шина хранения
        в подсети перекладывает собранное в бочку. Другая шина хранения на основной сети (отфильтрована на ломтики арбуза и с высоким приоритетом)
        предоставляет основной сети доступ к собранным предметам.
    </BoxAnnotation>

  <IsometricCamera yaw="270" pitch="30" />
</GameScene>