---
navigation:
  title: Начало начал (1.20+)
  position: 10
---

<div class="notification is-info">
  Приведенная ниже информация относится только к Applied Energistics 2 в Minecraft 1.20 и новее.
</div>

# Начало начал

## Получение исходного материала

<GameScene zoom="4" background="transparent">
  <ImportStructure src="assets/assemblies/meteor_interior.snbt" />
</GameScene>

Для начала работы с Applied Energistics 2 необходимо найти [метеориты](ae2-mechanics/meteorites.md). Они довольно распространены и, как правило, оставляют огромные дыры в рельефе, так что Вы наверняка встречали такие в своих путешествиях.
Если нет, то можно изготовить <ItemLink id="meteorite_compass" />, который укажет на ближайший <ItemLink id="mysterious_cube" />.

Найдя метеорит, пройдите в его центр. В центре Вы найдете кластеры истинного кварца, зарождающийся истинный кварц, [цветущие блоки истинного кварца](items-blocks-machines/budding_certus.md) различных типов и таинственный куб.

Добывайте кластеры истинного кварца и все найденные блоки истинного кварца. Вы также можете собирать цветущие блоки истинного кварца, но без шелкового касания они потеряют 1 уровень качества.

Не ломайте безупрецные цветущие блоки истинного кварца, так как даже с шелковым касанием он превратится в потресканный зарождающийся кварц, и восстановить его до совершенного будет невозможно.

Также добывайте Таинственный куб в центре метеорита, чтобы получить все 4 пресса для высекателя.

## Выращивание истинного кварца

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_certus_1.snbt" />
</GameScene>

Бутоны истинного кварца прорастают из [цветущих блоков истинного кварца](items-blocks-machines/budding_certus.md), аналогично аметисту. Если сломать бутон, который не закончил
рост, из него выпадет одна <ItemLink id="certus_quartz_dust" />, на что не влияет удача. Если сломать полностью выросший кластер, то из него выпадет четыре
<ItemLink id="certus_quartz_crystal" />, в данном случае удача увеличивает это число. 

Существует 4 типа зарождающихся истинных блоков: Безупречный, потресканный, осколочный и поврежденный.

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_blocks.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Каждый раз, когда бутон вырастает еще на одну ступень, цветущий блок имеет шанс снизиться на один уровень, превратившись в итоге в
обычный блок истинного кварца. Их можно восстановить (и создать новые зарождающиеся блоки), бросив этот блок (или блок истинного кварца)
в воду с одним или несколькими <ItemLink id="charged_certus_quartz_crystal" />.

<RecipeFor id="damaged_budding_quartz" />

Совершенные цветущие блоки не разрушаются и генерируют истинный кварц бесконечно. Однако их нельзя изготовить или переместить
киркой, даже с помощью шелкового касания. (их *можно* перемещать с помощью [пространсвенного хранилища](ae2-mechanics/spatial-io.md) )

Сами по себе бутоны истинного кварца растут очень медленно. К счастью <ItemLink id="growth_accelerator" /> значительно
ускоряет этот процесс, если поместить его рядом с зарождающимся блоком. Построить несколько таких блоков - ваша первоочередная задача.

<GameScene zoom="4" background="transparent">
<ImportStructure src="assets/assemblies/budding_certus_2.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Если у Вас недостаточно кварца, чтобы сделать ещё и <ItemLink id="energy_acceptor" /> или <ItemLink id="vibration_chamber" />,
можно сделать <ItemLink id="crank" /> и прикрепить его к концу ускорителя.

Автоматический сбор кварца [описан тут](example-setups/simple-certus-farm.md).

## Небольшое замечание об изменчивом кристалле

Еще один материал, который вам понадобится, - изменчивый кристалл, с которым Вы уже сталкивались при изготовлении ускорителей роста. Его получают, бросая в воду заряженный истинный кварц, красный камень и чистый кварц. Автоматическое изготовление изменчивого кристалла "оставлено на усмотрение читателя."

<ItemLink id="charger" /> требуется для производства <ItemLink id="charged_certus_quartz_crystal" />, если Вы еще не сделали этого.

## Высечение некоторых процессоров

При обыске метеорита Вы найдете четыре "пресса", полученных при разбивании Таинственного куба. Они используются в <ItemLink id="inscriber" /> для изготовления трех типов процессоров.

<ItemGrid>
  <ItemIcon id="silicon_press" />

  <ItemIcon id="logic_processor_press" />

  <ItemIcon id="calculation_processor_press" />

  <ItemIcon id="engineering_processor_press" />
</ItemGrid>

Высекатель - это односторонняя машина, подобная ванильной печи. При вставке сверху или снизу предметы помещаются в верхний или нижний слот, а при вставке сбоку или сзади - в центральный слот. Результаты могут быть извлечены сбоку или сзади.

Для облегчения автоматизации работы с воронками (и, возможно, уменьшения количества "помех" из труб) высекатели можно поворачивать с помощью <ItemLink id="certus_quartz_wrench" />.

Произведите несколько процессоров каждого типа для подготовки к следующему шагу, создав базовую МЭ систему. Автоматизация производства процессоров "оставлена на усмотрение читателя".

## Технологии энергии материи: МЭ сеть и хранилище

### Что такое МЭ-хранилище?

В переводе с английского М-Э означает "материя-энергия".

Энергия материи - основной компонент Applied Energistics 2, это как версия многоблочного сундука, созданная безумными учеными,
и он может произвести революцию в вашей ситуации с хранением. МЭ сильно отличается от других систем хранения в Minecraft, и
чтобы привыкнуть к нему, может потребоваться несколько нестандартное мышление; но как только Вы начнете работать, огромные объемы хранилища в крошечном пространстве и терминалы множественного доступа станут для Вас настоящей революцией.
и терминалы множественного доступа - это лишь вершина айсберга ваших возможностей.

### Что нужно знать для начала работы?

Во-первых, МЭ хранит элементы внутри других элементов, называемых [Ячейки хранения](items-blocks-machines/storage_cells.md); имеется 5 уровней с постоянно увеличивающимися объемами
хранения. Для использования ячейки хранения она должна быть размещена либо внутри <ItemLink id="chest" />,
или в <ItemLink id="drive" />.

<ItemLink id="chest" /> показывает содержимое ячейки, как только она помещается внутрь, и Вы можете добавлять и удалять из нее предметы, как если бы это был <ItemLink id="minecraft:chest" />, за исключением того, что элементы
фактически хранятся в ячейках хранилища, а не в самом <ItemLink id="chest" />.

Хотя <ItemLink id="chest" /> - это отличный способ познакомиться с концепцией МЭ, для того чтобы действительно 
воспользоваться ее преимуществами, необходимо установить [МЭ сеть](ae2-mechanics/me-network-connections.md).

## Ваша первая МЭ система

Теперь, когда у Вас есть все основные материалы и механизмы для Applied Energistics 2, Вы можете создать свою первую МЭ-систему. Это будет очень простая система, без автокрафта, без логистики, просто хорошее, простое хранилище с возможностью поиска вещей.

<GameScene zoom="6" interactive={true}>
<ImportStructure src="assets/assemblies/tiny_me_system.snbt" />

</GameScene>

*   Список ингредиентов:
    * 1x <ItemLink id="drive" />
    * 1x <ItemLink id="terminal" /> or <ItemLink id="crafting_terminal" />
    * 1x <ItemLink id="energy_acceptor" />
    * Несколько [кабелей](items-blocks-machines/cables.md), либо стеклянные, либо закрытые, либо умные, но не плотные
    * Несколько [ячеек](items-blocks-machines/storage_cells.md), рекомендуется использовать 4k для хорошего сочетания
    емкости и типов (эффективнее была бы [поделенная](items-blocks-machines/cell_workbench.md) смесь 4k и 1k, но это уже сложности, которые мы сейчас не будем рассматривать)
---
1.  Поместите дисковод вниз.
2.  Приёмник энергии (и некоторые другие AE2 [устройства](ae2-mechanics/devices.md)) работает в двух режимах - кубическом и плоском. Их можно переключать в сетке крафта. Если ваш приемник энергии имеет форму куба, положите его рядом с накопителем. Если это плоский квадрат, положите на дисковод кабель и установите на него приемник.
3.  Подайте энергию в приемник энергии с помощью кабеля/трубы/провода от вашего основного энергогенерирующего мода.
4.  Положите кабель на верхнюю часть накопителя (или иным образом на уровне глаз) и установите на него свой терминал или терминал создания.
5.  Поместите ячейки хранения в дисковод
6.  Выгода
7.  Работа с настройками терминала
8.  Удовлетворитесь своей исключительной силой и способностью
9.  Осознайте, что эта сеть, по большому счету, довольно мала

### Расширение сети

Итак, у Вас есть базовое хранилище и доступ к нему, это хорошее начало, но, скорее всего, Вы захотите 
автоматизировать некоторые процессы.

Отличным примером является размещение <ItemLink id="export_bus" /> на вершине печи для 
сброса руды, и <ItemLink id="import_bus" />
на дне печи для извлечения руды.

<ItemLink id="export_bus" /> позволяет экспортировать предметы из сети в подключенный
инвентарь, в то время как <ItemLink id="import_bus" /> импортирует предметы из подключенного инвентаря в
сеть.

### Преодоление ограничений

На данный момент вы, вероятно, приближаетесь к отметке 8 или около того [устройств](ae2-mechanics/devices.md), при достижении 9 единиц устройств вам придется начать
управлять [каналами](ae2-mechanics/channels.md). Большинство устройств требуют наличия канала для функционирования.

По умолчанию сеть поддерживает 8 каналов, при нарушении этого ограничения необходимо добавить
<ItemLink id="controller" /> в сеть. Это позволяет значительно её расширить.
[Умные кабели](items-blocks-machines/cables.md) позволят вам увидеть, как каналы направляются по вашей сети. Используйте их в начале работы, чтобы узнать, как работают каналы, или если у Вас много красного и светящегося камня.
