---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Интерфейс
  icon: interface
  position: 210
categories:
- devices
item_ids:
- ae2:interface
- ae2:cable_interface
---

# Интерфейс

<Row gap="20">
<BlockImage id="interface" scale="8" />
<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/cable_interface.snbt" />
</GameScene>
</Row>

Интерфейсы действуют как небольшой сундук и резервуар для жидкости, который наполняется из [хранилища сети](../ae2-mechanics/import-export-storage.md) и опустошается в нем
в зависимости от того, какой запас вы зададите в его слотах. Он старается выполнить это за один игровой такт, поэтому он может заполнить собой
или опустошить до 9 стаков за один игровой такт, что делает его быстрым методом импорта или экспорта, если у вас есть быстрые трубы для предметов.

Еще одна полезная особенность: в то время как большинство резервуаров для жидкостей могут хранить только один тип жидкости, интерфейсы могут хранить до 9, а также предметы.
По сути, это просто сундуки/многожидкостные резервуары с некоторыми дополнительными функциями, которые можно предотвратить, отключив их от сети.
Таким образом, они полезны в некоторых нишевых случаях, когда требуется хранить небольшое количество различных предметов.

## Особые взаимодействия

Интерфейсы также имеют несколько специальных функций с другими [устройствами](../ae2-mechanics/devices.md) AE2:

<ItemLink id="storage_bus" /> на неконфигурированном интерфейсе будет представлять все [хранилищу сети](../ae2-mechanics/import-export-storage.md)
своей сети в сеть шины хранения, как если бы сеть интерфейса представляла собой один большой сундук, на который помещена шина хранения.
Задание запаса предметов в слотах фильтра интерфейса отключает эту функцию.

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/interface_storage.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

МЭ интерфейсы имеют особое взаимодействие с интерфейсами [подсетей](../ae2-mechanics/subnetworks.md): если интерфейс не сконфигурирован, 
он будет полностью пропускать интерфейс и пересылать данные непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md) этой подсети,
пропуская интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующую партию до тех пор, пока не освободится место в хранилище.

<GameScene zoom="6" background="transparent">
<ImportStructure src="../assets/assemblies/furnace_automation.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Варианты

Интерфейсы бывают двух вариантов: обычные и плоские/[подчасть](../ae2-mechanics/cable-subparts.md). Это влияет на то, с каких конкретно сторон можно получить доступ к их запасам
и к каким сторонам они предоставляют сетевое соединение.

* Обычные интерфейсы позволяют предметам толкать, вытаскивать и получать доступ к своим запасам со всех сторон и, как и большинство машин AE2, действуют
    как кабель, обеспечивающий сетевое соединение со всеми сторонами.

* Плоские интерфейсы представляют собой [кабельную подчасть](../ae2-mechanics/cable-subparts.md), и поэтому на одном кабеле можно разместить несколько интерфейсов, что позволяет создавать компактные системы.
    Они позволяют предметам отталкиваться от своего лица, извлекать его и получать доступ к своему инвентарю, но не обеспечивают сетевого соединения на лице.

Интерфейсы можно менять местами с обычными и плоскими в сетке крафта.

## Настройки

Верхние слоты интерфейса определяют, что интерфейс настроен на хранение внутри себя. Когда в них что-то помещается
или перетаскивается из JEI/REI, появляется гаечный ключ, позволяющий установить количество.

## Улучшения
Интерфейс поддерживает следующие [улучшения](upgrade_cards.md):

* <ItemLink id="fuzzy_card" /> позволяет шине фильтровать по уровню урона и/или игнорировать NBT предметов.
* <ItemLink id="crafting_card" /> позволяет интерфейсу отправлять запросы на крафтинг в вашу систему [автокрафта](../ae2-mechanics/autocrafting.md)
    для получения желаемых предметов.

## Приоритет

Приоритеты могут быть установлены нажатием на гаечный ключ в правом верхнем углу графического интерфейса. Интерфейсы с более высоким приоритетом получат свои элементы
раньше, чем интерфейсы с более низким приоритетом,
## Рецепты

<Recipe id="network/blocks/interfaces_interface" />

<RecipeFor id="cable_interface" />
