---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Излучатель уровня
  icon: level_emitter
  position: 220
categories:
- devices
item_ids:
- ae2:level_emitter
- ae2:energy_level_emitter
---

# Излучатель уровня

<GameScene zoom="8" background="transparent">
  <ImportStructure src="../assets/blocks/level_emitter.snbt" />
</GameScene>

Излучатель уровня излучает сигнал красного камня в зависимости от количества предмета в
[хранилищи сети](../ae2-mechanics/import-export-storage.md).

Существует также версия, излучающая сигнал красного камня в зависимости от количества [энергии](../ae2-mechanics/energy.md), хранящейся
в вашей сети.

Это [кабельная подчасть](../ae2-mechanics/cable-subparts.md).

В отличие от других [устройств](../ae2-mechanics/devices.md), излучатели уровня *не* требуют [канал](../ae2-mechanics/channels.md).

## Настройки

* Излучатель уровня может быть установлен в режим "больше/равно" или "меньше".
* Когда вставляется <ItemLink id="crafting_card" />, можно установить режим "испускать красный камень во время создания предмета" или
    "испускать красный камень для создания предмета"

## Улучшения

Излучатель уровня поддерживает следующие [улучшения](upgrade_cards.md):

* <ItemLink id="fuzzy_card" /> позволяет излучателю фильтровать по уровню урона и/или игнорировать NBT предмета.
* <ItemLink id="crafting_card" /> включает функциональность крафтинга.

## Функциональность крафта

Если вставить <ItemLink id="crafting_card" />, то излучатель будет переведен в режим крафта.

Это позволяет использовать две опции:

Первая опция, "излучать красный камень при крафте предмета", заставляет излучатель излучать сигнал красного камня, пока ваш [автокрафт](../ae2-mechanics/autocrafting.md)
создает определенный предмет через <ItemLink id="pattern_provider" />. Это полезно для включения только определенных
энергоемких автоматических установок, когда они действительно используются.

Вторая опция, "испускать красный камень для создания предмета", чрезвычайно полезна для таких специфических случаев, как бесконечные фермы и
автоматизированные установки, у которых есть только шанс получить результат, а не гарантированный результат.
Эта настройка создает виртуальный [шаблон](patterns.md) для [автокрафта](../ae2-mechanics/autocrafting.md), который будет использоваться для любого предмета.
(Для корректной функциональности фактический шаблон для этого же элемента **не должен существовать** в вашем <ItemLink id="pattern_provider" />).

Этот "шаблон" не определяет ингредиенты и даже не заботится о них.
Все, что он говорит, это "Если вы излучаете красный камень из излучателя этого уровня, то система ME получит этот предмет в какой-то момент в
ближайшем или отдаленном будущем". Обычно это используется для активации и деактивации бесконечных ферм, которые не требуют ввода ингредиентов,или для активации системы, обрабатывающей рекурсивные рецепты (которые стандартный автокафтинг не понимает), например, "1 булыжник = 2 булыжника",
если у вас есть машина, которая дублирует булыжник.

## Рецепт

<RecipeFor id="level_emitter" />

<RecipeFor id="energy_level_emitter" />
